/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.retention.manager;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.model.retention.RuleScope;
import com.atlassian.confluence.api.model.retention.TrashRetentionRule;
import com.atlassian.confluence.api.service.retention.RetentionFeatureChecker;
import com.atlassian.confluence.dmz.pages.TrashManagerInternal;
import com.atlassian.confluence.impl.cluster.lock.ClusterLockExecutionService;
import com.atlassian.confluence.impl.retention.RemovalType;
import com.atlassian.confluence.impl.retention.analytics.TrashRemovalJobCompletedEvent;
import com.atlassian.confluence.impl.retention.analytics.TrashRemovalStatisticHolder;
import com.atlassian.confluence.impl.retention.analytics.TrashRemovalStatisticThreadLocal;
import com.atlassian.confluence.impl.retention.manager.AbstractTrashRemovalManager;
import com.atlassian.confluence.impl.retention.manager.GlobalRetentionPolicyManager;
import com.atlassian.confluence.impl.retention.rules.EvaluatedTrash;
import com.atlassian.confluence.impl.retention.rules.TrashRuleEvaluator;
import com.atlassian.confluence.impl.retention.status.TrashCleanupJobStatus;
import com.atlassian.confluence.impl.retention.status.TrashCleanupJobStatusManager;
import com.atlassian.confluence.util.Cleanup;
import com.atlassian.event.api.EventPublisher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class DefaultTrashRemovalManager
extends AbstractTrashRemovalManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultTrashRemovalManager.class);
    public static final String DEFAULT_TRASH_REMOVAL_SOFT_CLUSTER_LOCK_NAME = "default_trash_removal_soft_lock";
    public static final String DEFAULT_TRASH_REMOVAL_HARD_CLUSTER_LOCK_NAME = "default_trash_removal_hard_lock";

    public DefaultTrashRemovalManager(GlobalRetentionPolicyManager globalRetentionPolicyManager, TrashCleanupJobStatusManager jobStatusManager, TrashManagerInternal trashManagerInternal, PlatformTransactionManager transactionManager, RetentionFeatureChecker retentionFeatureChecker, TrashRuleEvaluator trashRuleEvaluator, EventPublisher eventPublisher, ClusterLockExecutionService clusterLockExecutionService) {
        super(globalRetentionPolicyManager, jobStatusManager, trashManagerInternal, transactionManager, retentionFeatureChecker, trashRuleEvaluator, eventPublisher, clusterLockExecutionService);
    }

    @Override
    public void hardRemove() {
        this.clusterLockExecutionService.doWithLock(DEFAULT_TRASH_REMOVAL_HARD_CLUSTER_LOCK_NAME, "Default trash hard remove", this::internalHardRemove);
    }

    @Override
    public void softRemove(int limit) {
        this.clusterLockExecutionService.doWithLock(DEFAULT_TRASH_REMOVAL_SOFT_CLUSTER_LOCK_NAME, "Default trash soft remove", () -> this.internalSoftRemove(limit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void internalSoftRemove(int limit) {
        log.debug("Beginning soft removal of trash");
        TrashCleanupJobStatus status = this.jobStatusManager.getCurrentStatus();
        TrashRemovalStatisticHolder statisticHolder = new TrashRemovalStatisticHolder();
        try {
            this.cleanupTrashedEntitiesWithRetry(limit, statisticHolder, status);
        }
        finally {
            this.jobStatusManager.setCurrentStatus(status);
        }
        this.eventPublisher.publish((Object)new TrashRemovalJobCompletedEvent(RemovalType.SOFT, statisticHolder));
        log.debug("Finished soft removal of trash");
    }

    @VisibleForTesting
    void internalHardRemove() {
        log.debug("Beginning HARD removal of trash");
        TrashRemovalStatisticHolder statisticHolder = new TrashRemovalStatisticHolder();
        TrashCleanupJobStatus status = new TrashCleanupJobStatus();
        do {
            this.cleanupTrashedEntitiesWithRetry(DefaultTrashRemovalManager.getBatchSize(), statisticHolder, status);
        } while (status.getNextContentIdOffset() != DEFAULT_CONTENT_ID_OFFSET.longValue());
        this.eventPublisher.publish((Object)new TrashRemovalJobCompletedEvent(RemovalType.HARD, statisticHolder));
        log.debug("Finished hard removal of trash");
    }

    private void cleanupTrashedEntitiesWithRetry(int limit, TrashRemovalStatisticHolder statisticHolder, TrashCleanupJobStatus status) {
        long nextContentIdOffset = status.getNextContentIdOffset();
        TrashRetentionRule globalRule = this.globalRetentionPolicyManager.getPolicy().getTrashRetentionRule();
        List<Long> failedTrashIds = this.cleanupTrashedEntities(globalRule, nextContentIdOffset, limit, statisticHolder, status);
        if (!failedTrashIds.isEmpty()) {
            for (long trashId : failedTrashIds) {
                boolean deleted = this.cleanupTrashedEntities(globalRule, trashId, 1, statisticHolder, status).isEmpty();
                if (deleted) continue;
                log.error("Error purging trash with id {}", (Object)trashId);
            }
        }
    }

    private List<Long> cleanupTrashedEntities(TrashRetentionRule globalRule, long contentIdOffset, int limit, TrashRemovalStatisticHolder statisticHolder, TrashCleanupJobStatus jobStatus) {
        ArrayList failedTrashIds = new ArrayList();
        AtomicBoolean deletionFailed = new AtomicBoolean(false);
        try (Cleanup ignore = this.setCacheMode();){
            this.getTransactionTemplate().execute(transactionStatus -> {
                try {
                    List trashedEntities = this.trashManagerInternal.getTrashedEntities(contentIdOffset, limit);
                    if (log.isDebugEnabled()) {
                        log.debug("Found {} trashed entities. Applying trash retention rules ...", (Object)trashedEntities.size());
                    }
                    List<EvaluatedTrash> evaluatedTrashes = this.trashRuleEvaluator.evaluate(globalRule, trashedEntities);
                    jobStatus.setNextContentIdOffset(this.determineNextContentIdOffset(evaluatedTrashes, limit));
                    failedTrashIds.addAll(evaluatedTrashes.stream().filter(EvaluatedTrash::shouldBeDeleted).map(trash -> trash.getTrash().getId()).toList());
                    TrashRemovalStatisticThreadLocal.withStatistic(statisticHolder.getGlobalStats(), () -> this.deleteForRule(evaluatedTrashes, RuleScope.GLOBAL));
                    TrashRemovalStatisticThreadLocal.withStatistic(statisticHolder.getSpaceStats(), () -> this.deleteForRule(evaluatedTrashes, RuleScope.SPACE));
                }
                catch (Exception e) {
                    log.error("Error default trash removal", (Throwable)e);
                    deletionFailed.set(true);
                    jobStatus.setNextContentIdOffset(contentIdOffset + (long)limit);
                    transactionStatus.setRollbackOnly();
                }
                return null;
            });
        }
        return deletionFailed.get() ? failedTrashIds : Collections.emptyList();
    }
}

