/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.retention.schedule;

import com.atlassian.confluence.api.service.retention.RetentionFeatureChecker;
import com.atlassian.confluence.impl.retention.RetentionType;
import com.atlassian.confluence.impl.retention.fast.FastTrashRemovalManager;
import com.atlassian.confluence.impl.retention.manager.TrashRemovalManager;
import com.atlassian.confluence.impl.retention.rules.RetentionRulesChecker;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrashSoftRemovalScheduledJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(TrashSoftRemovalScheduledJob.class);
    private final RetentionFeatureChecker retentionFeatureChecker;
    private final RetentionRulesChecker rulesChecker;
    private final TrashRemovalManager trashRemovalManager;
    private final FastTrashRemovalManager fastTrashRemovalManager;
    public static final String BATCH_SIZE_KEY = "confluence.trash.soft.removal.batch.size";
    public static final int BATCH_SIZE = Integer.getInteger("confluence.trash.soft.removal.batch.size", 100);

    public TrashSoftRemovalScheduledJob(RetentionFeatureChecker retentionFeatureChecker, RetentionRulesChecker rulesChecker, TrashRemovalManager trashRemovalManager, FastTrashRemovalManager fastTrashRemovalManager) {
        this.retentionFeatureChecker = retentionFeatureChecker;
        this.rulesChecker = rulesChecker;
        this.trashRemovalManager = trashRemovalManager;
        this.fastTrashRemovalManager = fastTrashRemovalManager;
    }

    public @Nullable JobRunnerResponse runJob(JobRunnerRequest ignored) {
        if (this.retentionFeatureChecker.isFeatureAvailable()) {
            if (this.rulesChecker.hasDeletingRule(RetentionType.TRASH)) {
                if (this.fastTrashRemovalManager.isEnabled()) {
                    this.fastTrashRemovalManager.softRemove(FastTrashRemovalManager.globalTrashDeleteSizePerJob());
                } else {
                    this.trashRemovalManager.softRemove(BATCH_SIZE);
                }
            } else {
                log.info("There is no deleting rules for trash. Skipping soft removal job.");
            }
        }
        return JobRunnerResponse.success();
    }
}

