/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.retention.status;

import com.atlassian.confluence.impl.retention.status.TrashCleanupJobStatus;
import com.atlassian.confluence.impl.retention.status.TrashCleanupJobStatusManager;
import com.atlassian.confluence.util.DefaultObjectMapperProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public abstract class AbstractTrashCleanupJobStatusManager
implements TrashCleanupJobStatusManager {
    protected final PluginSettings globalPluginSettings;
    protected final ObjectMapper objectMapper;

    public AbstractTrashCleanupJobStatusManager(PluginSettingsFactory pluginSettingsFactory) {
        this(pluginSettingsFactory, new DefaultObjectMapperProvider().getObjectMapper());
    }

    protected AbstractTrashCleanupJobStatusManager(PluginSettingsFactory pluginSettingsFactory, ObjectMapper objectMapper) {
        this.globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.objectMapper = objectMapper;
    }

    public abstract String getStatusPluginSettingsKey();

    @Override
    public void setCurrentStatus(TrashCleanupJobStatus status) {
        try {
            this.globalPluginSettings.put(this.getStatusPluginSettingsKey(), (Object)this.objectMapper.writeValueAsString((Object)status));
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot store current job status", e);
        }
    }

    @Override
    public TrashCleanupJobStatus getCurrentStatus() {
        Object status = this.globalPluginSettings.get(this.getStatusPluginSettingsKey());
        return this.parseStatusFromPluginSettingsValue(status);
    }

    protected abstract TrashCleanupJobStatus parseStatusFromPluginSettingsValue(Object var1);
}

