/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.misc;

import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class RateLimitedConsumer<T>
implements Consumer<T> {
    private final ConcurrentHashMap<T, Instant> lastRun = new ConcurrentHashMap();
    private final Consumer<T> callback;
    private final long minimumIntervalMs;

    public RateLimitedConsumer(Consumer<T> callback, long minimumIntervalMs) {
        this.callback = callback;
        this.minimumIntervalMs = minimumIntervalMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(T key) {
        Instant submissionTime = Instant.now();
        Instant latestPermittedLastRun = submissionTime.minusMillis(this.minimumIntervalMs);
        if (latestPermittedLastRun.isAfter(this.lastRun.getOrDefault(key, Instant.EPOCH))) {
            boolean shouldRun = false;
            T t = key;
            synchronized (t) {
                if (latestPermittedLastRun.isAfter(this.lastRun.getOrDefault(key, Instant.EPOCH))) {
                    this.lastRun.put(key, submissionTime);
                    shouldRun = true;
                }
            }
            if (shouldRun) {
                this.callback.accept(key);
            }
        }
    }
}

