/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.fields.usertype;

import com.atlassian.confluence.plugins.cql.spi.fields.AbstractUserFieldHandler;
import com.atlassian.confluence.plugins.cql.spi.fields.UserSubFieldFactory;
import com.atlassian.confluence.plugins.cql.v2search.query.UserQuery;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.query.AbstractUserQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.MatchNoDocsQuery;
import com.atlassian.querylang.fields.TextFieldHandler;
import com.atlassian.querylang.fields.expressiondata.TextExpressionData;
import com.atlassian.querylang.query.SearchQuery;
import com.google.common.collect.Sets;
import java.util.HashSet;

public final class UserFieldHandler
extends AbstractUserFieldHandler
implements TextFieldHandler {
    private static final String FIELD_NAME = "user";

    public UserFieldHandler(UserSubFieldFactory subFieldFactory) {
        super(FIELD_NAME, subFieldFactory);
    }

    public SearchQuery build(TextExpressionData expressionData, String value) {
        this.validateSupportedOp((Enum)((TextExpressionData.Operator)expressionData.getOperator()), Sets.newHashSet((Object[])new TextExpressionData.Operator[]{TextExpressionData.Operator.CONTAINS, TextExpressionData.Operator.NOT_CONTAINS}));
        TextFieldHandler handler = (TextFieldHandler)this.getSubfieldHandlersAsMap().get("fullname");
        return handler.build(expressionData, value);
    }

    public com.atlassian.confluence.search.v2.SearchQuery createUserQuery(AbstractUserQuery.Parameter ... params) {
        if (params.length == 0) {
            return MatchNoDocsQuery.getInstance();
        }
        HashSet<String> userKeys = new HashSet<String>();
        HashSet<String> usernames = new HashSet<String>();
        for (AbstractUserQuery.Parameter param : params) {
            param.getUserKey().ifPresentOrElse(key -> userKeys.add(key.getStringValue()), () -> param.getUsername().ifPresent(usernames::add));
        }
        return (com.atlassian.confluence.search.v2.SearchQuery)BooleanQuery.builder().addShould((Object)new UserQuery(userKeys, UserQuery.UserQueryType.USERKEY)).addShould((Object)new UserQuery(usernames, UserQuery.UserQueryType.USERNAME)).build();
    }

    protected String getIndexFieldName() {
        return SearchFieldMappings.USER_KEY.getName();
    }
}

