/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.plugins.cql.impl.SearchTypeManager;
import com.atlassian.confluence.plugins.cql.rest.CQLMetaDataService;
import com.atlassian.confluence.plugins.cql.rest.DisplayableType;
import com.atlassian.confluence.plugins.cql.rest.model.QueryExpression;
import com.atlassian.confluence.plugins.cql.rest.model.QueryField;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.Map;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/")
public class CQLMetaDataResource {
    public static final String EXPRESSIONS_PATH = "expressions";
    private final CQLMetaDataService metadataService;
    private final SearchTypeManager searchTypeManager;

    @Inject
    public CQLMetaDataResource(CQLMetaDataService metadataService, SearchTypeManager searchTypeManager) {
        this.metadataService = metadataService;
        this.searchTypeManager = searchTypeManager;
    }

    @Path(value="fields")
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Map<QueryField.FieldType, Iterable<QueryField>> fields(@QueryParam(value="filter") CQLMetaDataService.GetFieldsFilter filter) {
        return this.metadataService.getFields(filter);
    }

    @Path(value="contenttypes")
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Collection<DisplayableType> contentTypes(@QueryParam(value="category") @DefaultValue(value="content") String category) {
        switch (category.toLowerCase()) {
            case "all": {
                return this.searchTypeManager.getTypes().values();
            }
            case "content": {
                return this.searchTypeManager.getContentTypes().values();
            }
        }
        throw new BadRequestException("Unrecognised type category : " + category);
    }

    @Path(value="expressions")
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Iterable<QueryExpression> getExpressions(@QueryParam(value="cql") String cql) {
        if (Strings.isNullOrEmpty((String)cql)) {
            throw new BadRequestException("cql query param is required");
        }
        return this.metadataService.parseExpressions(cql, null);
    }

    private static class TypeCategories {
        private static final String ALL = "all";
        private static final String CONTENT = "content";
        private static final String SPACE = "space";
        private static final String USER = "user";

        private TypeCategories() {
        }
    }
}

