/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.v2search.query;

import com.atlassian.confluence.plugins.cql.v2search.query.AbstractUserFieldQuery;
import com.atlassian.confluence.search.v2.query.AbstractUserQuery;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.Entity;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;

public class MentionQuery
extends AbstractUserFieldQuery {
    public static final String MENTION_FIELD = "mentions";

    public MentionQuery(String ... username) {
        super(Arrays.asList(username));
    }

    public MentionQuery(UserAccessor userAccessor, UserKey ... userKeys) {
        this(MentionQuery.getUsernameFromKey(userAccessor, userKeys));
    }

    public MentionQuery(UserAccessor userAccessor, AbstractUserQuery.Parameter ... parameters) {
        this(MentionQuery.getUsernames(userAccessor, Stream.of(parameters)));
    }

    private static String[] getUsernameFromKey(UserAccessor userAccessor, UserKey ... userKeys) {
        return MentionQuery.getUsernames(userAccessor, Stream.of(userKeys).map(userKey -> new AbstractUserQuery.Parameter(userKey, null)));
    }

    private static String[] getUsernames(UserAccessor userAccessor, Stream<AbstractUserQuery.Parameter> parameters) {
        return (String[])parameters.map(p -> MentionQuery.getUsername(userAccessor, p)).flatMap(Optional::stream).toArray(String[]::new);
    }

    private static Optional<String> getUsername(UserAccessor userAccessor, AbstractUserQuery.Parameter param) {
        return param.getUsername().or(() -> param.getUserKey().map(arg_0 -> ((UserAccessor)userAccessor).getUserByKey(arg_0)).map(Entity::getName));
    }

    @Override
    public String getFieldName() {
        return MENTION_FIELD;
    }
}

