/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.v2search.query;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.plugins.cql.v2search.extractor.CqlFieldMappings;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.TermQuery;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ParentIdQuery
implements SearchQuery {
    private static final String KEY = "parentId";
    private final List<ContentId> parentIds;

    public ParentIdQuery(ContentId ... parentIds) {
        this.parentIds = ImmutableList.copyOf((Object[])parentIds);
    }

    public String getKey() {
        return KEY;
    }

    public List<ContentId> getParameters() {
        return this.parentIds;
    }

    public SearchQuery expand() {
        BooleanQuery.Builder builder = BooleanQuery.builder();
        for (ContentId contentId : this.parentIds) {
            SearchQuery attachmentQuery = (SearchQuery)BooleanQuery.builder().addMust((Object)new TermQuery(CqlFieldMappings.PAGE_OR_COMMENT_PARENT_ID.getName(), contentId.serialise())).addShould((Object)new TermQuery(SearchFieldMappings.TYPE.getName(), ContentTypeEnum.PAGE.getRepresentation())).addShould((Object)new TermQuery(SearchFieldMappings.TYPE.getName(), ContentTypeEnum.COMMENT.getRepresentation())).build();
            builder.addShould((Object)attachmentQuery);
        }
        return builder.build();
    }
}

