/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.v2search.query;

import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.MatchNoDocsQuery;
import com.atlassian.confluence.search.v2.query.TermQuery;
import com.atlassian.confluence.search.v2.query.TermSetQuery;
import com.atlassian.confluence.search.v2.query.TextFieldQuery;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class UserQuery
implements SearchQuery {
    public static final String CQL_USER_QUERY = "cqlUserQuery";
    private final UserQueryType queryType;
    private final Set<String> queries;

    public UserQuery(String query, UserQueryType queryType) {
        this(Set.of(query), queryType);
    }

    public UserQuery(Set<String> queries, UserQueryType queryType) {
        this.queries = queries;
        this.queryType = queryType;
    }

    public String getKey() {
        return CQL_USER_QUERY;
    }

    public List<String> getParameters() {
        return List.copyOf(this.queries);
    }

    public SearchQuery expand() {
        return (SearchQuery)BooleanQuery.builder().addMust((Object)this.getFieldQuery()).addMust((Object)new TermQuery(SearchFieldMappings.TYPE.getName(), ContentTypeEnum.PERSONAL_INFORMATION.getRepresentation())).build();
    }

    SearchQuery getFieldQuery() {
        if (this.queries.isEmpty()) {
            return MatchNoDocsQuery.getInstance();
        }
        switch (this.queryType.ordinal()) {
            case 2: {
                return BooleanQuery.composeOrQuery(this.queries.stream().map(query -> new TextFieldQuery(SearchFieldMappings.FULL_NAME.getName(), query, BooleanOperator.AND)).collect(Collectors.toSet()));
            }
            case 1: {
                return new TermSetQuery(SearchFieldMappings.USER_KEY.getName(), this.queries);
            }
            case 0: {
                return BooleanQuery.composeOrQuery(this.queries.stream().map(query -> new TextFieldQuery(SearchFieldMappings.USER_NAME.getName(), query, BooleanOperator.AND)).collect(Collectors.toSet()));
            }
        }
        throw new UnsupportedOperationException("Unknown field " + String.valueOf((Object)this.queryType));
    }

    public static enum UserQueryType {
        USERNAME,
        USERKEY,
        FULLNAME;

    }
}

