/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.quickreload;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.plugins.quickreload.QuickReloadCaches;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UnrestrictedAccess
public class QuickReloadFilter
implements Filter {
    private static final Pattern PATH_INFO_PATTERN = Pattern.compile("/quickreload/latest/(\\d+)");
    private final QuickReloadCaches caches;

    public QuickReloadFilter(QuickReloadCaches caches) {
        this.caches = caches;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        Matcher matcher = PATH_INFO_PATTERN.matcher(servletRequest.getPathInfo());
        Long pageId = matcher.matches() ? QuickReloadFilter.tryParseLong(matcher.group(1)) : null;
        Long since = QuickReloadFilter.tryParseLong(servletRequest.getParameter("since"));
        if (pageId == null || since == null || this.caches.hasAccessModeUpdate(since) || this.caches.hasUpdates(pageId, since)) {
            chain.doFilter(request, response);
        } else {
            response.setContentType("application/json");
            ((HttpServletResponse)response).setStatus(204);
            response.flushBuffer();
        }
    }

    public void destroy() {
    }

    private static Long tryParseLong(String val) {
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

