/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.entities;

import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.plugins.rest.jackson2.entities.CommentEntityTreeExpander;
import com.atlassian.confluence.plugins.rest.jackson2.entities.ContentEntity;
import com.atlassian.plugins.rest.api.expand.annotation.Expander;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@XmlRootElement(name="comments")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Expander(value=CommentEntityTreeExpander.class)
public class CommentEntityTree {
    @XmlElement(name="content")
    private List<ContentEntity> contents;
    @XmlAttribute(name="total")
    private int total;
    @XmlTransient
    private final List<Comment> comments;

    public CommentEntityTree() {
        this.comments = new ArrayList<Comment>();
        this.total = 0;
    }

    public CommentEntityTree(int total, List<Comment> comments) {
        this.comments = comments;
        this.total = total;
    }

    public int getTotal() {
        return this.total;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setContents(List<ContentEntity> contents) {
        this.contents = contents;
    }

    public List<ContentEntity> getContents() {
        return this.contents;
    }

    public String toString() {
        return new StringJoiner(", ", CommentEntityTree.class.getSimpleName() + "[", "]").add("contents=" + String.valueOf(this.contents)).add("total=" + this.total).add("comments=" + String.valueOf(this.comments)).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommentEntityTree)) {
            return false;
        }
        CommentEntityTree that = (CommentEntityTree)o;
        return this.total == that.total && Objects.equals(this.contents, that.contents) && Objects.equals(this.comments, that.comments);
    }

    public int hashCode() {
        return Objects.hash(this.total, this.contents, this.comments);
    }
}

