/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.entities;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.plugins.rest.jackson2.entities.CommentEntityTree;
import com.atlassian.confluence.plugins.rest.jackson2.entities.ContentEntity;
import com.atlassian.confluence.plugins.rest.jackson2.entities.ContentEntityList;
import com.atlassian.confluence.plugins.rest.jackson2.manager.RestContentManager;
import com.atlassian.plugins.rest.api.expand.expander.AbstractEntityExpander;
import java.util.ArrayList;
import java.util.List;

public class CommentEntityTreeExpander
extends AbstractEntityExpander<CommentEntityTree> {
    private RestContentManager restContentManager;

    public CommentEntityTreeExpander(RestContentManager restContentManager) {
        this.restContentManager = restContentManager;
    }

    protected CommentEntityTree expandInternal(CommentEntityTree entity) {
        List<Comment> comments = entity.getComments();
        ArrayList<ContentEntity> entities = new ArrayList<ContentEntity>();
        for (Comment comment : comments) {
            ContentEntity commentEntity = this.restContentManager.convertToContentEntity((ContentEntityObject)comment);
            this.restContentManager.expand(commentEntity);
            entities.add(commentEntity);
        }
        entity.setContents(this.getChildrenList(entities, null).getContents());
        return entity;
    }

    private ContentEntityList getChildrenList(List<ContentEntity> entities, String parentId) {
        List<ContentEntity> topLevelEntities = this.getChildren(entities, parentId);
        ContentEntityList contents = new ContentEntityList(topLevelEntities.size(), null);
        contents.setContents(topLevelEntities);
        return contents;
    }

    private List<ContentEntity> getChildren(List<ContentEntity> entities, String parentId) {
        ArrayList<ContentEntity> children = new ArrayList<ContentEntity>();
        for (ContentEntity e : entities) {
            if ((parentId != null || e.getParentId() != null) && (parentId == null || e.getParentId() == null || !parentId.equals(e.getParentId()))) continue;
            children.add(e);
            e.setChildren(this.getChildrenList(entities, e.getId()));
        }
        return children;
    }
}

