/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.entities;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.net.URI;
import java.util.Objects;

@XmlRootElement
public class Link {
    @XmlAttribute
    private final URI href;
    @XmlAttribute
    private final String type;
    @XmlAttribute
    private final String rel;

    private Link() {
        this.href = null;
        this.rel = null;
        this.type = null;
    }

    private Link(URI href, String rel, String type) {
        this.href = Objects.requireNonNull(href);
        this.rel = Objects.requireNonNull(rel);
        this.type = type;
    }

    public static Link link(URI uri, String rel) {
        return new Link(uri, rel, null);
    }

    public static Link link(URI uri, String rel, String type) {
        return new Link(uri, rel, type);
    }

    public static Link self(URI uri) {
        return Link.link(uri, "self");
    }

    public static Link edit(URI uri) {
        return Link.link(uri, "edit");
    }

    public static Link add(URI uri) {
        return Link.link(uri, "add");
    }

    public static Link delete(URI uri) {
        return Link.link(uri, "delete");
    }

    public URI getHref() {
        return this.href;
    }

    public String getRel() {
        return this.rel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.rel == null ? 0 : this.rel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Link other = (Link)obj;
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.rel == null) {
            return other.rel == null;
        }
        return this.rel.equals(other.rel);
    }

    public String toString() {
        return "Link{href=" + String.valueOf(this.href) + ", type='" + this.type + "', rel='" + this.rel + "'}";
    }
}

