/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.entities;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.plugins.rest.jackson2.entities.LabelEntityBuilder;
import com.atlassian.confluence.plugins.rest.jackson2.entities.LabelEntityList;
import com.atlassian.confluence.plugins.rest.jackson2.entities.Link;
import com.atlassian.confluence.plugins.rest.jackson2.entities.SpaceEntityUserPermissions;
import com.atlassian.confluence.plugins.rest.jackson2.entities.SpaceEntityUserProperties;
import com.atlassian.confluence.plugins.rest.jackson2.manager.RequestContextThreadLocal;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceLogo;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.userstatus.FavouriteManager;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.plugins.rest.api.expand.expander.AbstractEntityExpander;
import com.atlassian.user.User;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;

public class SpaceEntityUserPropertiesExpander
extends AbstractEntityExpander<SpaceEntityUserProperties> {
    private final FavouriteManager favouriteManager;
    private final SpaceManager spaceManager;
    private final GlobalSettingsManager settingsManager;
    private static final String ANONYMOUS_USERNAME = "null";

    public SpaceEntityUserPropertiesExpander(FavouriteManager favouriteManager, SpaceManager spaceManager, GlobalSettingsManager settingsManager) {
        this.favouriteManager = favouriteManager;
        this.spaceManager = spaceManager;
        this.settingsManager = settingsManager;
    }

    protected SpaceEntityUserProperties expandInternal(SpaceEntityUserProperties entity) {
        ConfluenceUser user = RequestContextThreadLocal.get().getUser();
        Space space = Objects.requireNonNull(this.spaceManager.getSpace(entity.getSpaceKey()));
        entity.setFavourite(this.favouriteManager.isUserFavourite(user, space));
        String username = user != null ? user.getName() : ANONYMOUS_USERNAME;
        entity.setEffectiveUser(username);
        SpaceEntityUserPermissions availablePermissions = new SpaceEntityUserPermissions(space.getKey(), username);
        entity.setPermissions(availablePermissions);
        SpaceDescription spaceDescription = space.getDescription();
        LabelEntityList labels = this.convertToLabelEntityList(spaceDescription.getVisibleLabels((User)user));
        entity.setLabels(labels);
        try {
            SpaceLogo logo = this.spaceManager.getLogoForSpace(space.getKey());
            entity.setLogo(Link.link(new URI(this.settingsManager.getGlobalSettings().getBaseUrl() + logo.getDownloadPath()), "logo", Thumbnail.MimeType.PNG.toString()));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return entity;
    }

    private LabelEntityList convertToLabelEntityList(List<Label> labels) {
        LabelEntityList list = new LabelEntityList();
        LabelEntityBuilder builder = new LabelEntityBuilder();
        for (Label label : labels) {
            list.addLabel(builder.build(label));
        }
        return list;
    }
}

