/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.entities;

import com.atlassian.confluence.core.VersionHistory;
import com.atlassian.confluence.upgrade.UpgradeHistoryService;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Date;
import java.util.Objects;
import java.util.StringJoiner;

@XmlRootElement(name="attachment")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class VersionHistoryEntity {
    @XmlAttribute
    private String versionTag;
    @XmlAttribute
    private int buildNumber;
    @XmlAttribute
    private Date installationDate;

    public VersionHistoryEntity(VersionHistory versionHistory) {
        this.installationDate = versionHistory.getInstallationDate();
        this.buildNumber = versionHistory.getBuildNumber();
        this.versionTag = versionHistory.getVersionTag();
    }

    public VersionHistoryEntity(UpgradeHistoryService.Upgrade upgrade) {
        this.installationDate = upgrade.installationDate() == null ? null : Date.from(upgrade.installationDate());
        this.buildNumber = upgrade.buildNumber();
        this.versionTag = upgrade.versionTag();
    }

    public String toString() {
        return new StringJoiner(", ", VersionHistoryEntity.class.getSimpleName() + "[", "]").add("versionTag='" + this.versionTag + "'").add("buildNumber=" + this.buildNumber).add("installationDate=" + String.valueOf(this.installationDate)).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionHistoryEntity)) {
            return false;
        }
        VersionHistoryEntity that = (VersionHistoryEntity)o;
        return this.buildNumber == that.buildNumber && Objects.equals(this.versionTag, that.versionTag) && Objects.equals(this.installationDate, that.installationDate);
    }

    public int hashCode() {
        return Objects.hash(this.versionTag, this.buildNumber, this.installationDate);
    }
}

