/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.entities.builders;

import com.atlassian.confluence.content.ContentTypeManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.HasLinkWikiMarkup;
import com.atlassian.confluence.dmz.hibernate.AnyTypeDaoInternal;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.rest.jackson2.entities.builders.AttachmentEntityBuilder;
import com.atlassian.confluence.plugins.rest.jackson2.entities.builders.CommentEntityBuilder;
import com.atlassian.confluence.plugins.rest.jackson2.entities.builders.ContentEntityBuilder;
import com.atlassian.confluence.plugins.rest.jackson2.entities.builders.CustomContentEntityBuilder;
import com.atlassian.confluence.plugins.rest.jackson2.entities.builders.DefaultContentEntityBuilder;
import com.atlassian.confluence.plugins.rest.jackson2.entities.builders.EntityBuilderFactory;
import com.atlassian.confluence.plugins.rest.jackson2.entities.builders.PageContentEntityBuilder;
import com.atlassian.confluence.plugins.rest.jackson2.entities.builders.PersonalInformationContentEntityBuilder;
import com.atlassian.confluence.plugins.rest.jackson2.entities.builders.SearchEntityBuilder;
import com.atlassian.confluence.plugins.rest.jackson2.entities.builders.SpaceEntityBuilder;
import com.atlassian.confluence.plugins.rest.jackson2.entities.builders.WikiLinkableContentEntityBuilder;
import com.atlassian.confluence.plugins.rest.jackson2.manager.DateEntityFactory;
import com.atlassian.confluence.plugins.rest.jackson2.manager.DefaultRestAttachmentManager;
import com.atlassian.confluence.plugins.rest.jackson2.manager.UserEntityHelper;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.avatar.AvatarProviderAccessor;

public class DefaultEntityBuilderFactory
implements EntityBuilderFactory {
    private final UserEntityHelper userEntityHelper;
    private final GlobalSettingsManager settingsManager;
    private final DateEntityFactory dateEntityFactory;
    private final DefaultRestAttachmentManager restAttachmentManager;
    private final AnyTypeDaoInternal anyTypeDao;
    private final UserAccessor userAccessor;
    private final ContentTypeManager contentTypeManager;
    private final AvatarProviderAccessor avatarProviderAccessor;
    private final AttachmentManager attachmentManager;

    public DefaultEntityBuilderFactory(GlobalSettingsManager settingsManager, DateEntityFactory dateEntityFactory, DefaultRestAttachmentManager restAttachmentManager, AnyTypeDaoInternal anyTypeDao, UserAccessor userAccessor, UserEntityHelper userEntityHelper, ContentTypeManager contentTypeManager, AvatarProviderAccessor avatarProviderAccessor, AttachmentManager attachmentManager) {
        this.settingsManager = settingsManager;
        this.dateEntityFactory = dateEntityFactory;
        this.restAttachmentManager = restAttachmentManager;
        this.anyTypeDao = anyTypeDao;
        this.userAccessor = userAccessor;
        this.userEntityHelper = userEntityHelper;
        this.contentTypeManager = contentTypeManager;
        this.avatarProviderAccessor = avatarProviderAccessor;
        this.attachmentManager = attachmentManager;
    }

    @Override
    public SearchEntityBuilder createBuilder(String type) {
        ContentTypeEnum contentType = ContentTypeEnum.getByRepresentation((String)type);
        if (contentType == null) {
            throw new IllegalArgumentException("type can not be null");
        }
        return switch (contentType) {
            case ContentTypeEnum.PERSONAL_SPACE_DESCRIPTION, ContentTypeEnum.SPACE_DESCRIPTION -> new SpaceEntityBuilder(this.dateEntityFactory, this.settingsManager, this.anyTypeDao);
            case ContentTypeEnum.ATTACHMENT -> new AttachmentEntityBuilder(this.anyTypeDao, this.restAttachmentManager);
            case ContentTypeEnum.BLOG, ContentTypeEnum.PAGE -> new PageContentEntityBuilder(this.settingsManager, this.dateEntityFactory, this.userEntityHelper);
            case ContentTypeEnum.COMMENT -> new CommentEntityBuilder(this.settingsManager, this.dateEntityFactory, this.userEntityHelper);
            case ContentTypeEnum.PERSONAL_INFORMATION -> new PersonalInformationContentEntityBuilder(this.settingsManager, this.dateEntityFactory, this.userAccessor, this.userEntityHelper, this.avatarProviderAccessor, this.attachmentManager);
            case ContentTypeEnum.CUSTOM -> new CustomContentEntityBuilder(this.settingsManager, this.dateEntityFactory, this.userEntityHelper, this.contentTypeManager);
            default -> new DefaultContentEntityBuilder(this.settingsManager, this.dateEntityFactory, this.userEntityHelper);
        };
    }

    @Override
    public <T extends ContentEntityObject> ContentEntityBuilder<? super T> createContentEntityBuilder(Class<? extends T> clazz) {
        if (PersonalInformation.class.isAssignableFrom(clazz)) {
            return new PersonalInformationContentEntityBuilder(this.settingsManager, this.dateEntityFactory, this.userAccessor, this.userEntityHelper, this.avatarProviderAccessor, this.attachmentManager);
        }
        if (Page.class.isAssignableFrom(clazz)) {
            return new PageContentEntityBuilder(this.settingsManager, this.dateEntityFactory, this.userEntityHelper);
        }
        if (Comment.class.isAssignableFrom(clazz)) {
            return new CommentEntityBuilder(this.settingsManager, this.dateEntityFactory, this.userEntityHelper);
        }
        if (HasLinkWikiMarkup.class.isAssignableFrom(clazz)) {
            return new WikiLinkableContentEntityBuilder(this.settingsManager, this.dateEntityFactory, this.userEntityHelper);
        }
        return new DefaultContentEntityBuilder(this.settingsManager, this.dateEntityFactory, this.userEntityHelper);
    }
}

