/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.entities.builders;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugins.rest.jackson2.entities.ContentEntity;
import com.atlassian.confluence.plugins.rest.jackson2.entities.Link;
import com.atlassian.confluence.plugins.rest.jackson2.entities.SearchResultEntity;
import com.atlassian.confluence.plugins.rest.jackson2.entities.builders.WikiLinkableContentEntityBuilder;
import com.atlassian.confluence.plugins.rest.jackson2.manager.DateEntityFactory;
import com.atlassian.confluence.plugins.rest.jackson2.manager.UserEntityHelper;
import com.atlassian.confluence.search.contentnames.SearchResult;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.avatar.AvatarProviderAccessor;
import com.atlassian.confluence.user.avatar.ConfluenceAvatarOwner;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.plugins.avatar.AbstractAvatar;
import com.atlassian.plugins.avatar.Avatar;
import com.atlassian.plugins.avatar.AvatarOwner;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonalInformationContentEntityBuilder
extends WikiLinkableContentEntityBuilder<PersonalInformation> {
    private static final String PROFILE_PICTURE_BUILTIN_PATH = "/images/icons/profilepics/";
    private static final Logger log = LoggerFactory.getLogger(PersonalInformationContentEntityBuilder.class);
    static final String USER = "user";
    private final UserAccessor userAccessor;
    private final AvatarProviderAccessor avatarProviderAccessor;
    private final AttachmentManager attachmentManager;

    public PersonalInformationContentEntityBuilder(GlobalSettingsManager settingsManager, DateEntityFactory dateEntityFactory, UserAccessor userAccessor, UserEntityHelper userEntityHelper, AvatarProviderAccessor avatarProviderAccessor, AttachmentManager attachmentManager) {
        super(settingsManager, dateEntityFactory, userEntityHelper);
        this.userAccessor = userAccessor;
        this.avatarProviderAccessor = avatarProviderAccessor;
        this.attachmentManager = attachmentManager;
    }

    @Override
    public ContentEntity build(PersonalInformation personalInfo) {
        ContentEntity contentEntity = super.build(personalInfo);
        String username = personalInfo.getUser() == null ? null : personalInfo.getUser().getName();
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        if (user == null) {
            return null;
        }
        contentEntity.setTitle(user.getFullName());
        String profilePictureUrl = this.userAccessor.getUserProfilePicture((User)user).getUriReference();
        contentEntity.setThumbnailLink(this.getThumbnailLink(profilePictureUrl));
        contentEntity.setUsername(username);
        contentEntity.setUserKey(user.getKey());
        contentEntity.setLastModifiedDate(null);
        return contentEntity;
    }

    private Link getThumbnailLink(String imageUrl) {
        try {
            return Link.link(new URI(imageUrl), "thumbnail", Thumbnail.MimeType.PNG.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    @Override
    public SearchResultEntity build(SearchResult result) {
        ContentEntity entity = (ContentEntity)super.build(result);
        String username = result.getPreviewKey();
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        if (user == null) {
            return null;
        }
        this.setUserProperties(entity, user);
        return entity;
    }

    private void setWikiLink(String username, ContentEntity entity) {
        if (username != null) {
            entity.setWikiLink("[~" + username + "]");
        } else {
            entity.setWikiLink(null);
        }
    }

    @Override
    public SearchResultEntity build(com.atlassian.confluence.search.v2.SearchResult result) {
        if ("true".equalsIgnoreCase(result.getField(SearchFieldMappings.IS_DEACTIVATED_USER.getName())) || "true".equalsIgnoreCase(result.getField(SearchFieldMappings.IS_EXTERNALLY_DELETED_USER.getName())) || "true".equalsIgnoreCase(result.getField(SearchFieldMappings.IS_SHADOWED_USER.getName()))) {
            return null;
        }
        ContentEntity entity = (ContentEntity)super.build(result);
        String username = result.getField("username");
        entity.setType(USER);
        entity.setUsername(username);
        entity.setUserKey(new UserKey(result.getField(SearchFieldMappings.USER_KEY.getName())));
        entity.setTitle(result.getField("fullName"));
        this.setWikiLink(username, entity);
        entity.setThumbnailLink(this.getThumbnailLink(this.getAvatar(result).getUrl()));
        entity.setLastModifiedDate(null);
        return entity;
    }

    private Avatar getAvatar(com.atlassian.confluence.search.v2.SearchResult sr) {
        return this.avatarProviderAccessor.getAvatarProvider().getAvatar((AvatarOwner)new ConfluenceAvatarOwner((User)new ConfluenceUserImpl(sr.getField("username"), sr.getField("fullName"), sr.getField("email"))), avatarOwner -> new AvatarImpl(avatarOwner.getIdentifier(), sr.getField(SearchFieldMappings.PROFILE_PICTURE_URL.getName())), 48);
    }

    private void setUserProperties(ContentEntity entity, ConfluenceUser user) {
        String name = user.getName();
        entity.setTitle(user.getFullName());
        entity.setThumbnailLink(this.getThumbnailLink(this.userAccessor.getUserProfilePicture((User)user).getUriReference()));
        entity.setType(USER);
        entity.setUsername(name);
        entity.setUserKey(user.getKey());
        this.setWikiLink(name, entity);
        entity.setLastModifiedDate(null);
    }

    private class AvatarImpl
    extends AbstractAvatar {
        private final String url;

        AvatarImpl(String ownerId, String url) {
            super(ownerId, "image/png", 48);
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isExternal() {
            return false;
        }

        public InputStream getBytes() throws IOException {
            String url = this.getUrl();
            if (url.startsWith(PersonalInformationContentEntityBuilder.PROFILE_PICTURE_BUILTIN_PATH)) {
                return ServletContextThreadLocal.getContext().getResourceAsStream(url);
            }
            Optional attachment = PersonalInformationContentEntityBuilder.this.attachmentManager.findAttachmentForDownloadPath(url);
            if (attachment.isEmpty()) {
                log.warn("Unable to get bytes of profile picture [{}] for the user [{}]", (Object)url, (Object)this.getOwnerId());
                throw new IOException("Unable to get bytes for " + url);
            }
            return PersonalInformationContentEntityBuilder.this.attachmentManager.getAttachmentData((Attachment)attachment.get());
        }

        public Avatar atSize(int size) {
            return this;
        }
    }
}

