/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.filters.AbstractHttpFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@UnrestrictedAccess
public class CanUseFilter
extends AbstractHttpFilter {
    private final PermissionManager permissionManager;

    public CanUseFilter(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ConfluenceUser remoteUser = AuthenticatedUserThreadLocal.get();
        if (!this.canUseConfluenceCheck(remoteUser)) {
            if (remoteUser == null) {
                response.sendError(401);
            } else {
                response.sendError(403);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected boolean canUseConfluenceCheck(ConfluenceUser remoteUser) {
        return this.permissionManager.hasPermission(remoteUser, Permission.VIEW, PermissionManager.TARGET_APPLICATION);
    }
}

