/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.filter;

import com.atlassian.confluence.plugins.rest.jackson2.filter.HttpDateFormat;
import com.atlassian.confluence.plugins.rest.jackson2.resources.I18nResource;
import com.atlassian.confluence.plugins.rest.jersey.jackson2.cachecontrol.PreventCachingResponseFilter;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.util.Date;

@Provider
public class PrototypeApiCacheControlResourceFilterFactory
implements DynamicFeature {
    private static final int SHORT_TERM_EXPIRY_SECONDS = 600;
    private static final long SHORT_TERM_EXPIRY_MILLIS = 600000L;

    public void configure(ResourceInfo resourceInfo, FeatureContext featureContext) {
        if (resourceInfo.getResourceClass().equals(I18nResource.class)) {
            featureContext.register((Object)new PublicShortTermResponseFilter());
        }
        featureContext.register((Object)PreventCachingResponseFilter.INSTANCE);
    }

    private static class PublicShortTermResponseFilter
    implements ContainerResponseFilter {
        private PublicShortTermResponseFilter() {
        }

        public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) {
            MultivaluedMap headers = containerResponseContext.getHeaders();
            headers.putSingle((Object)"Cache-Control", (Object)"public, must-revalidate, max-age=600");
            headers.putSingle((Object)"Expires", (Object)HttpDateFormat.getPreferredDateFormat().format(new Date(System.currentTimeMillis() + 600000L)));
        }
    }
}

