/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.resources;

import com.atlassian.confluence.plugins.rest.jackson2.manager.RequestContext;
import com.atlassian.confluence.plugins.rest.jackson2.manager.RequestContextThreadLocal;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.exception.AuthenticationRequiredException;
import com.atlassian.seraph.auth.AuthenticationContext;
import com.atlassian.seraph.auth.AuthenticationContextImpl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.security.Principal;

public abstract class AbstractResource {
    protected final UserAccessor userAccessor;
    protected AuthenticationContext authContext = new AuthenticationContextImpl();
    @Context
    protected UriInfo uriInfo;
    private SpacePermissionManager spacePermissionManager;

    AbstractResource() {
        this.userAccessor = null;
    }

    public AbstractResource(UserAccessor userAccessor, SpacePermissionManager spm) {
        this.userAccessor = userAccessor;
        this.spacePermissionManager = spm;
    }

    protected UriBuilder getContentUriBuilder() {
        return this.uriInfo.getBaseUriBuilder().path("content").path("{id}");
    }

    protected UriBuilder getSpaceUriBuilder() {
        return this.uriInfo.getBaseUriBuilder().path("space").path("{key}");
    }

    protected UriBuilder getAttachmentUriBuilder() {
        return this.uriInfo.getBaseUriBuilder().path("attachment").path("{id}");
    }

    protected UriBuilder getUserUriBuilder() {
        return this.uriInfo.getBaseUriBuilder().path("user").path("non-system").path("{username}");
    }

    protected UriBuilder getAnonymousUserUriBuilder() {
        return this.uriInfo.getBaseUriBuilder().path("user").path("system").path("anonymous");
    }

    protected UriBuilder getMissingUserUriBuilder() {
        return this.uriInfo.getBaseUriBuilder().path("user").path("missing").queryParam("username", new Object[0]);
    }

    protected ConfluenceUser getCurrentUser() {
        return this.convertPrincipalToUser(this.authContext.getUser());
    }

    protected RequestContext createRequestContext() {
        if (this.authContext.getUser() == null && !this.spacePermissionManager.hasPermission("USECONFLUENCE", null, null)) {
            throw new AuthenticationRequiredException();
        }
        RequestContext requestContext = new RequestContext(this.getCurrentUser(), this.uriInfo.getBaseUriBuilder());
        requestContext.setUriBuilder("content", this.getContentUriBuilder());
        requestContext.setUriBuilder("space", this.getSpaceUriBuilder());
        requestContext.setUriBuilder("attachment", this.getAttachmentUriBuilder());
        requestContext.setUriBuilder("user/non-system", this.getUserUriBuilder());
        requestContext.setUriBuilder("user/system/anonymous", this.getAnonymousUserUriBuilder());
        requestContext.setUriBuilder("user/missing", this.getMissingUserUriBuilder());
        RequestContextThreadLocal.set(requestContext);
        return requestContext;
    }

    private ConfluenceUser convertPrincipalToUser(Principal principal) {
        if (principal == null) {
            return null;
        }
        if (principal instanceof ConfluenceUser) {
            return (ConfluenceUser)principal;
        }
        return this.userAccessor.getUserByName(principal.getName());
    }

    static Integer parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

