/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.rest.jackson2.entities.BuildInfoEntity;
import com.atlassian.confluence.plugins.rest.jackson2.entities.VersionHistoryEntity;
import com.atlassian.confluence.plugins.rest.jackson2.entities.VersionHistoryEntityList;
import com.atlassian.confluence.setup.BuildInformation;
import com.atlassian.confluence.upgrade.UpgradeHistoryService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;

@Path(value="/buildInfo")
@AnonymousSiteAccess
public class BuildInfoResource {
    private final UpgradeHistoryService upgradeHistoryService;

    @Inject
    public BuildInfoResource(@ComponentImport UpgradeHistoryService upgradeHistoryService) {
        this.upgradeHistoryService = upgradeHistoryService;
    }

    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getBuildId() {
        BuildInfoEntity entity = new BuildInfoEntity(BuildInformation.INSTANCE);
        return Response.ok((Object)entity).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/history")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getUpgradeHistory(@QueryParam(value="start-index") String startIndexString, @QueryParam(value="max-results") String maxResultsString) {
        int start = NumberUtils.toInt((String)startIndexString, (int)0);
        int maxResults = NumberUtils.toInt((String)maxResultsString, (int)90);
        return Response.ok((Object)new VersionHistoryEntityList(this.upgradeHistoryService.getUpgradeHistory(start, maxResults).stream().map(VersionHistoryEntity::new).collect(Collectors.toList()))).build();
    }
}

