/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.user.User;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@LicensedOnly
@Path(value="/content/{contentId}/watches")
@Produces(value={"application/json;charset=UTF-8"})
public class ContentWatchesResource {
    private final NotificationManager notificationManager;
    private final ContentEntityManager contentEntityManager;

    private ContentWatchesResource() {
        this.notificationManager = null;
        this.contentEntityManager = null;
    }

    @Inject
    public ContentWatchesResource(NotificationManager notificationManager, @Named(value="contentEntityManager") ContentEntityManager contentEntityManager) {
        this.notificationManager = notificationManager;
        this.contentEntityManager = contentEntityManager;
    }

    @SystemAdminOnly
    @GET
    @Produces(value={"application/json"})
    public Response getContentWatches(@PathParam(value="contentId") long contentId) {
        ContentEntityObject content = this.contentEntityManager.getById(contentId);
        if (content == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No content with contentId " + contentId + " found.")).build();
        }
        List notifications = this.notificationManager.getNotificationsByContent(content);
        return Response.ok(ContentWatchesResource.getResult(notifications)).build();
    }

    public static Map<String, Object> getResult(List<Notification> notifications) {
        LinkedList<Map<String, String>> data = new LinkedList<Map<String, String>>();
        for (Notification notification : notifications) {
            if (notification.getReceiver() == null) continue;
            data.add(Map.of("key", notification.getReceiver().getKey().getStringValue()));
        }
        return Map.of("count", notifications.size(), "data", data);
    }

    @POST
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response addContentWatch(@PathParam(value="contentId") long contentId) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        ContentEntityObject content = this.contentEntityManager.getById(contentId);
        if (content == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No content with contentId " + contentId + " found.")).build();
        }
        this.notificationManager.addContentNotification((User)user, content);
        return Response.ok().build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response removeContentWatch(@PathParam(value="contentId") long contentId) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        ContentEntityObject content = this.contentEntityManager.getById(contentId);
        if (content == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No content with contentId " + contentId + " found.")).build();
        }
        this.notificationManager.removeContentNotification((User)user, content);
        return Response.ok().build();
    }
}

