/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.plugins.rest.jackson2.resources.AbstractResource;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.i18n.PluginI18NResource;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.servlet.util.LastModifiedHandler;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.user.User;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/i18n")
@AnonymousSiteAccess
public class I18nResource
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(I18nResource.class);
    private final PluginAccessor pluginAccessor;
    private final LocaleManager localeManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final HttpContext httpContext;

    private I18nResource() {
        this.pluginAccessor = null;
        this.localeManager = null;
        this.i18NBeanFactory = null;
        this.httpContext = null;
    }

    @Inject
    public I18nResource(UserAccessor userAccessor, PluginAccessor pluginAccessor, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, HttpContext httpContext, SpacePermissionManager spacePermissionManager) {
        super(userAccessor, spacePermissionManager);
        this.pluginAccessor = pluginAccessor;
        this.localeManager = localeManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.httpContext = httpContext;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response get(@QueryParam(value="pluginKeys") Set<String> pluginKeys, @QueryParam(value="rawValue") @DefaultValue(value="false") boolean rawValue) {
        if (pluginKeys == null || pluginKeys.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (pluginKeys.size() == 1) {
            return this.getI18n(pluginKeys.iterator().next(), rawValue);
        }
        HashMap<String, String> i18nProperties = new HashMap<String, String>();
        I18NBean i18NBean = this.getI18nBean();
        for (String pluginKey : pluginKeys) {
            Plugin plugin = this.pluginAccessor.getEnabledPlugin(pluginKey);
            if (plugin == null) {
                log.error("Skipping plugin. Cannot find plugin to get i18n properties for: {}", (Object)pluginKey);
                continue;
            }
            this.loadI18nProperties(plugin, i18nProperties, i18NBean, rawValue);
        }
        return Response.ok(i18nProperties).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{key}")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getI18n(@PathParam(value="key") String pluginKey, @QueryParam(value="rawValue") @DefaultValue(value="false") boolean rawValue) {
        Plugin plugin = this.pluginAccessor.getEnabledPlugin(pluginKey);
        if (plugin == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (this.httpContext != null && this.httpContext.getActiveResponse() != null) {
            if (LastModifiedHandler.checkRequest((HttpServletRequest)this.httpContext.getActiveRequest(), (HttpServletResponse)this.httpContext.getActiveResponse(), (Date)plugin.getDateLoaded())) {
                return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
            }
        } else {
            log.error("\n\nhttpcontext null: {}", (Object)(this.httpContext == null ? 1 : 0));
            if (this.httpContext != null) {
                log.error("response null: {}\n\n", (Object)(this.httpContext.getActiveResponse() == null ? 1 : 0));
            }
        }
        HashMap<String, String> i18nProperties = new HashMap<String, String>();
        I18NBean i18NBean = this.getI18nBean();
        this.loadI18nProperties(plugin, i18nProperties, i18NBean, rawValue);
        return Response.ok(i18nProperties).build();
    }

    private I18NBean getI18nBean() {
        ConfluenceUser user = this.getCurrentUser();
        Locale locale = this.localeManager.getLocale((User)user);
        return this.i18NBeanFactory.getI18NBean(locale);
    }

    private void loadI18nProperties(Plugin plugin, Map<String, String> i18nProperties, I18NBean i18NBean, boolean rawValue) {
        for (ResourceDescriptor resourceDescriptor : plugin.getResourceDescriptors()) {
            if (!"i18n".equals(resourceDescriptor.getType())) continue;
            PluginI18NResource resource = new PluginI18NResource(plugin, resourceDescriptor);
            for (String keyStr : resource.getBundle().keySet()) {
                i18nProperties.put(keyStr, i18NBean.getText(keyStr, null, rawValue));
            }
        }
    }
}

