/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.resources;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.plugins.rest.jackson2.resources.AbstractResource;
import com.atlassian.confluence.plugins.rest.jackson2.service.ReIndexService;
import com.atlassian.confluence.search.IndexManager;
import com.atlassian.confluence.search.ReIndexOption;
import com.atlassian.confluence.search.ReIndexTask;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.spring.container.ContainerManager;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/index")
@Produces(value={"application/json;charset=UTF-8"})
@SystemAdminOnly
public class IndexResource
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(IndexResource.class);
    private final IndexManager indexManager;
    private final ReIndexService reIndexService;

    private IndexResource() {
        this.indexManager = (IndexManager)ContainerManager.getComponent((String)"indexManager", IndexManager.class);
        this.reIndexService = (ReIndexService)ContainerManager.getComponent((String)"indexService", ReIndexService.class);
    }

    @Deprecated(since="8.3.0", forRemoval=true)
    public IndexResource(IndexManager indexManager) {
        this.indexManager = indexManager;
        this.reIndexService = (ReIndexService)ContainerManager.getComponent((String)"indexService", ReIndexService.class);
    }

    @Inject
    public IndexResource(IndexManager indexManager, ReIndexService reIndexService) {
        this.indexManager = indexManager;
        this.reIndexService = reIndexService;
    }

    @Path(value="/reindex")
    @Consumes(value={"application/json"})
    @POST
    @AdminOnly
    @ReadOnlyAccessAllowed
    public Response reindex(@QueryParam(value="option") List<String> options, @QueryParam(value="spaceKey") List<String> spaceKeys) throws InterruptedException {
        if (this.reIndexService.isReIndexing()) {
            log.warn("Confluence is re-indexing");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Confluence is re-indexing").build();
        }
        EnumSet reIndexOptions = ReIndexOption.deserialise(options, (boolean)spaceKeys.isEmpty());
        if (this.reIndexService.reindex(spaceKeys, reIndexOptions)) {
            return Response.ok((Object)new ReIndexTaskEntity()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Path(value="/resetjob")
    @Consumes(value={"application/json"})
    @PUT
    @AdminOnly
    @ReadOnlyAccessAllowed
    public Response resetJob() {
        this.reIndexService.resetJobStatus();
        return Response.ok().build();
    }

    @Path(value="/reindex")
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response reIndexStatus() {
        ReIndexTask indexingTask = this.indexManager.getLastReindexingTask();
        if (indexingTask != null) {
            return Response.ok((Object)ReIndexTaskEntity.from(indexingTask)).build();
        }
        return Response.ok((Object)"Reindex status not available.").build();
    }

    @Path(value="/unindex")
    @Consumes(value={"application/json"})
    @POST
    @AdminOnly
    public Response unIndexAll() {
        this.indexManager.unIndexAll();
        return Response.ok().build();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class ReIndexTaskEntity {
        private boolean finished = false;
        private int percentageComplete = 0;
        private String elapsedTime = "0";
        private String remainingTime = "0";
        private int jobID;

        ReIndexTaskEntity() {
        }

        static ReIndexTaskEntity from(ReIndexTask reIndexTask) {
            ReIndexTaskEntity entity = new ReIndexTaskEntity();
            entity.finished = reIndexTask.isFinishedReindexing();
            entity.percentageComplete = reIndexTask.getProgress().getPercentComplete();
            entity.elapsedTime = reIndexTask.getCompactElapsedTime();
            entity.jobID = reIndexTask.getJobID();
            return entity;
        }

        @VisibleForTesting
        public int getJobID() {
            return this.jobID;
        }
    }
}

