/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.plugins.rest.jackson2.resources.ContentWatchesResource;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.user.User;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;

@LicensedOnly
@Path(value="/label/{labelId}/watches")
@Produces(value={"application/json;charset=UTF-8"})
public class LabelWatchesResource {
    private final NotificationManager notificationManager;
    private final LabelManager labelManager;

    private LabelWatchesResource() {
        this.notificationManager = null;
        this.labelManager = null;
    }

    @Inject
    public LabelWatchesResource(NotificationManager notificationManager, LabelManager labelManager) {
        this.notificationManager = notificationManager;
        this.labelManager = labelManager;
    }

    @SystemAdminOnly
    @GET
    @Produces(value={"application/json"})
    public Response getLabelWatches(@PathParam(value="labelId") long labelId) {
        Label label = this.labelManager.getLabel(labelId);
        if (label == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No label with labelId " + labelId + " found.")).build();
        }
        List notifications = this.notificationManager.getNotificationsByLabel(label);
        return Response.ok(ContentWatchesResource.getResult(notifications)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response addLabelWatch(@PathParam(value="labelId") long labelId) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Label label = this.labelManager.getLabel(labelId);
        if (label == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No label with labelId " + labelId + " found.")).build();
        }
        this.notificationManager.addLabelNotification((User)user, label);
        return Response.ok().build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response removeLabelWatch(@PathParam(value="labelId") long labelId) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Label label = this.labelManager.getLabel(labelId);
        if (label == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No label with labelId " + labelId + " found.")).build();
        }
        this.notificationManager.removeLabelNotification((User)user, label);
        return Response.ok().build();
    }
}

