/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.rest.jackson2.entities.ContentEntity;
import com.atlassian.confluence.plugins.rest.jackson2.manager.RestContentManager;
import com.atlassian.confluence.plugins.rest.jackson2.resources.AbstractResource;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Set;

@Deprecated
@Path(value="/content")
@AnonymousSiteAccess
public class PrototypeContentResource
extends AbstractResource {
    private final RestContentManager restContentManager;
    private static final int DEFAULT_MAX_SIZE = 50;

    private PrototypeContentResource() {
        this.restContentManager = null;
    }

    @Inject
    public PrototypeContentResource(UserAccessor userAccessor, RestContentManager restContentManager, SpacePermissionManager spacePermissionManager) {
        super(userAccessor, spacePermissionManager);
        this.restContentManager = restContentManager;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response get() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/{id}")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getContent(@PathParam(value="id") Long id) {
        this.createRequestContext();
        ContentEntity entity = this.restContentManager.getContentEntity(id, true);
        return entity == null ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.ok((Object)entity).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/{id}/attachments")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getAttachments(@PathParam(value="id") Long id, @QueryParam(value="start-index") String startIndexString, @QueryParam(value="max-results") String maxResultsString, @QueryParam(value="mimeType") Set<String> mime, @QueryParam(value="attachmentType") Set<String> nice, @QueryParam(value="reverseOrder") @DefaultValue(value="false") boolean reverseOrder) {
        this.createRequestContext();
        ContentEntity entity = this.restContentManager.getContentEntity(id, true);
        if (entity == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Integer startIndex = PrototypeContentResource.parseInt(startIndexString);
        Integer maxResults = PrototypeContentResource.parseInt(maxResultsString);
        if (startIndex == null && startIndexString != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (startIndex == null) {
            startIndex = 0;
        }
        if (maxResults == null && maxResultsString != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (maxResults == null) {
            maxResults = 50;
        }
        int start = Math.max(0, startIndex);
        if ((mime == null || mime.isEmpty()) && (nice == null || nice.isEmpty())) {
            entity.getAttachments().buildAttachmentListFromWrapper(startIndex, maxResults);
        } else if (mime != null && !mime.isEmpty()) {
            entity.getAttachments().buildFilteredByMimeTypeAttachmentList(start, maxResults, mime);
        } else {
            entity.getAttachments().buildFilteredByNiceTypeAttachmentList(start, maxResults, nice);
        }
        if (reverseOrder) {
            entity.getAttachments().reverse();
        }
        return Response.ok((Object)entity.getAttachments()).build();
    }
}

