/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.plugins.rest.jackson2.entities.SearchResultEntity;
import com.atlassian.confluence.plugins.rest.jackson2.entities.SearchResultEntityList;
import com.atlassian.confluence.plugins.rest.jackson2.resources.AbstractResource;
import com.atlassian.confluence.plugins.rest.jackson2.service.RestSearchParameters;
import com.atlassian.confluence.plugins.rest.jackson2.service.RestSearchService;
import com.atlassian.confluence.plugins.rest.jackson2.service.SearchServiceException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;

@Deprecated
@Path(value="/search")
@AnonymousSiteAccess
public class PrototypeSearchService
extends AbstractResource {
    private RestSearchService searchService;
    private PermissionManager permissionManager;
    private static final String SEARCH_SITE = "site";
    private static final String SEARCH_NAME = "name";
    private static final String SEARCH_USER = "user";
    private ScopesRequestCacheDelegate scopesRequestCacheDelegate;

    private PrototypeSearchService() {
    }

    @Inject
    public PrototypeSearchService(UserAccessor userAccessor, RestSearchService searchService, SpacePermissionManager spacePermissionManager, PermissionManager permissionManager, ScopesRequestCacheDelegate scopesRequestCacheDelegate) {
        super(userAccessor, spacePermissionManager);
        this.searchService = searchService;
        this.permissionManager = permissionManager;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @ScopesAllowed(requiredScope={"READ", "JSM_KB"})
    public Response doSearch(@QueryParam(value="query") String query, @QueryParam(value="type") String type, @DefaultValue(value="site") @QueryParam(value="search") String search, @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="max-results") Integer maxResults, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="attachmentType") Set<String> attachmentType, @QueryParam(value="label") Set<String> label, @DefaultValue(value="true") @QueryParam(value="groupResults") boolean groupResults, @DefaultValue(value="false") @QueryParam(value="searchParentName") boolean searchParentName, @QueryParam(value="preferredSpaceKey") String preferredSpaceKey, @QueryParam(value="maxResultsPerGroup") Integer maxResultsPerGroup, @QueryParam(value="xoauth_requestor_id") String username) {
        if (this.scopesRequestCacheDelegate != null && this.scopesRequestCacheDelegate.isScopePermitted("JSM_KB") && username != null) {
            AuthenticatedUserThreadLocal.setUser((User)this.userAccessor.getUser(username));
        }
        if (SEARCH_NAME.equals(search)) {
            return this.doContentNameSearch(query, type, spaceKey, attachmentType, label, groupResults, searchParentName, preferredSpaceKey, startIndex, pageSize, maxResultsPerGroup);
        }
        if (SEARCH_USER.equals(search)) {
            return this.doUserSearch(query, maxResults, false);
        }
        return this.doSiteSearch(query, type, spaceKey, attachmentType, label, startIndex, pageSize);
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/site")
    @ScopesAllowed(requiredScope={"READ"})
    public Response doSiteSearch(@QueryParam(value="query") String query, @QueryParam(value="type") String type, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="attachmentType") Set<String> attachmentType, @QueryParam(value="label") Set<String> label, @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @QueryParam(value="pageSize") Integer pageSize) {
        try {
            this.createRequestContext();
            RestSearchParameters parameters = new RestSearchParameters(query, type, spaceKey, attachmentType, label, false, null);
            return Response.ok((Object)this.searchService.fullSearch(parameters, startIndex, pageSize)).build();
        }
        catch (SearchServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/name")
    @ScopesAllowed(requiredScope={"READ"})
    public Response doContentNameSearch(@QueryParam(value="query") String query, @QueryParam(value="type") String type, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="attachmentType") Set<String> attachmentType, @QueryParam(value="label") Set<String> label, @DefaultValue(value="true") @QueryParam(value="groupResults") boolean groupResults, @DefaultValue(value="false") @QueryParam(value="searchParentName") boolean searchParentName, @QueryParam(value="preferredSpaceKey") String preferredSpaceKey, @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="maxResultsPerGroup") Integer maxResultsPerGroup) {
        try {
            this.createRequestContext();
            RestSearchParameters parameters = new RestSearchParameters(query, type, spaceKey, attachmentType, label, searchParentName, preferredSpaceKey);
            return Response.ok((Object)this.searchService.nameSearch(parameters, groupResults, startIndex, pageSize, maxResultsPerGroup)).build();
        }
        catch (SearchServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/user")
    @ScopesAllowed(requiredScope={"READ"})
    public Response doUserSearch(@QueryParam(value="query") String query, @QueryParam(value="max-results") int maxResults, @DefaultValue(value="false") @QueryParam(value="show-unlicensed") boolean showUnlicensed) {
        try {
            if (!this.canViewUserProfile()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.createRequestContext();
            return Response.ok((Object)this.searchService.userSearch(query, maxResults, showUnlicensed)).build();
        }
        catch (SearchServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/group")
    @ScopesAllowed(requiredScope={"READ"})
    public Response doGroupSearch(@QueryParam(value="query") String query, @QueryParam(value="max-results") int maxResults) {
        try {
            if (!this.canViewUserProfile()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.createRequestContext();
            return Response.ok((Object)this.searchService.groupSearch(query, maxResults)).build();
        }
        catch (SearchServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/user-or-group")
    @ScopesAllowed(requiredScope={"READ"})
    public Response doUserOrGroupSearch(@QueryParam(value="query") String query, @QueryParam(value="max-results") int maxResults) {
        try {
            if (!this.canViewUserProfile()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.createRequestContext();
            List<SearchResultEntity> users = this.searchService.userSearch(query, maxResults).getResults();
            List<SearchResultEntity> groups = this.searchService.groupSearch(query, maxResults).getResults();
            SearchResultEntityList combined = new SearchResultEntityList();
            combined.setResults((List<SearchResultEntity>)ImmutableList.copyOf(this.balancedConcat(users, groups, maxResults, 0.7f)));
            return Response.ok((Object)combined).build();
        }
        catch (SearchServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    private <E> Iterable<E> balancedConcat(Iterable<E> users, List<E> groups, int maxResults, float ratio) {
        int maxUsers = Math.max((int)((float)maxResults * ratio), maxResults - groups.size());
        return Iterables.limit((Iterable)Iterables.concat((Iterable)Iterables.limit(users, (int)maxUsers), groups), (int)maxResults);
    }

    private boolean canViewUserProfile() {
        return this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, User.class);
    }
}

