/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.rest.jackson2.entities.SpaceEntity;
import com.atlassian.confluence.plugins.rest.jackson2.entities.SpaceEntityListContext;
import com.atlassian.confluence.plugins.rest.jackson2.manager.RestSpaceManager;
import com.atlassian.confluence.plugins.rest.jackson2.resources.AbstractResource;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.Set;

@Deprecated
@Path(value="/space")
@AnonymousSiteAccess
public class PrototypeSpaceResource
extends AbstractResource {
    private final RestSpaceManager restSpaceManager;

    private PrototypeSpaceResource() {
        this.restSpaceManager = null;
    }

    @Inject
    public PrototypeSpaceResource(UserAccessor userAccessor, RestSpaceManager restSpaceManager, SpacePermissionManager spacePermissionManager) {
        super(userAccessor, spacePermissionManager);
        this.restSpaceManager = restSpaceManager;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response get(@QueryParam(value="type") @DefaultValue(value="all") String spaceTypeString, @QueryParam(value="start-index") String startIndexString, @QueryParam(value="max-results") String maxResultsString, @QueryParam(value="spaceKey") Set<String> spaceKey) {
        this.createRequestContext();
        Integer startIndex = PrototypeSpaceResource.parseInt(startIndexString);
        Integer maxResults = PrototypeSpaceResource.parseInt(maxResultsString);
        if (spaceKey == null) {
            spaceKey = Collections.emptySet();
        }
        SpaceEntityListContext ctx = new SpaceEntityListContext(spaceTypeString, startIndex, maxResults, spaceKey);
        return Response.ok((Object)this.restSpaceManager.getSpaceEntityList(ctx)).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/{key}")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getSpace(@PathParam(value="key") String key) {
        this.createRequestContext();
        SpaceEntity spaceEntity = this.restSpaceManager.getSpaceEntity(key, true);
        if (spaceEntity == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)spaceEntity).build();
    }
}

