/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rest.jackson2.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.rest.jackson2.entities.builders.UserEntityBuilder;
import com.atlassian.confluence.plugins.rest.jackson2.resources.AbstractResource;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.user.User;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;

@Deprecated
@Path(value="/user")
@AnonymousSiteAccess
public class PrototypeUserResource
extends AbstractResource {
    private UserAccessor userAccessor;
    private UserEntityBuilder userEntityBuilder;
    private PermissionManager permissionManager;

    private PrototypeUserResource() {
    }

    @Inject
    public PrototypeUserResource(UserAccessor userAccessor, PermissionManager permissionManager, WebResourceUrlProvider webResourceUrlProvider, SettingsManager settingsManager, I18NBeanFactory i18NBeanFactory, SpacePermissionManager spm) {
        super(userAccessor, spm);
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.userEntityBuilder = new UserEntityBuilder(userAccessor, (GlobalSettingsManager)settingsManager, webResourceUrlProvider, i18NBeanFactory);
    }

    @Path(value="system/anonymous")
    @GET
    @Produces(value={"application/xml", "application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getAnonymousUser() {
        this.createRequestContext();
        return Response.ok((Object)this.userEntityBuilder.buildAnonymous()).build();
    }

    @Path(value="current")
    @GET
    @Produces(value={"application/xml", "application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getLoggedInUser() {
        this.createRequestContext();
        if (this.getCurrentUser() == null) {
            return Response.seeOther((URI)this.getAnonymousUserUriBuilder().build(new Object[0])).build();
        }
        return Response.seeOther((URI)this.getUserUriBuilder().build(new Object[]{this.getCurrentUser().getName()})).build();
    }

    @Path(value="non-system/{username}")
    @GET
    @Produces(value={"application/xml", "application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getUser(@PathParam(value="username") String username) {
        this.createRequestContext();
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        if (user == null || !this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)user)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("User " + HtmlUtil.htmlEncode((String)username) + " does not exist, or you do not have permission to view.")).build();
        }
        return Response.ok((Object)this.userEntityBuilder.build((User)user)).build();
    }
}

