/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rebuildindex;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.search.SearchPlatformConfig;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@AnonymousSiteAccess
@WebSudoRequired
public class FrontendServlet
extends HttpServlet {
    private static final String RESOURCE_KEY = "com.atlassian.confluence.plugins.confluence-rebuild-index:confluence-rebuild-index-soy-resources";
    private static final String TEMPLATE_KEY = "confluence.rebuild.index.root";
    private static final String UNAUTHORISED_TEMPLATE_KEY = "confluence.rebuild.index.unauthorised";
    private static final String LEGACY_CONTENT_INDEX = "/admin/search-indexes.action";
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final ClusterManager clusterManager;
    private final UserManager userManager;
    private final DarkFeatureManager darkFeatureManager;
    private final LoginUriProvider loginUriProvider;
    private final SearchPlatformConfig searchPlatformConfig;

    @Autowired
    public FrontendServlet(@ComponentImport SoyTemplateRenderer soyTemplateRenderer, @ComponentImport DarkFeatureManager darkFeatureManager, @ComponentImport ClusterManager clusterManager, @ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport SearchPlatformConfig searchPlatformConfig) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.darkFeatureManager = darkFeatureManager;
        this.clusterManager = clusterManager;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.searchPlatformConfig = searchPlatformConfig;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, SoyException {
        Boolean isDarkFeatureEnabled = this.darkFeatureManager.isEnabledForAllUsers("confluence.reindex.improvements").orElse(false);
        if (!isDarkFeatureEnabled.booleanValue()) {
            response.sendRedirect(request.getContextPath() + LEGACY_CONTENT_INDEX);
            return;
        }
        UserKey user = this.userManager.getRemoteUserKey();
        if (user == null) {
            this.redirectToLogin(request, response);
            return;
        }
        if (!this.userManager.isAdmin(user)) {
            this.soyTemplateRenderer.render((Appendable)response.getWriter(), RESOURCE_KEY, UNAUTHORISED_TEMPLATE_KEY, Collections.emptyMap());
            return;
        }
        ImmutableMap data = ImmutableMap.of((Object)"isClustered", (Object)this.clusterManager.isClustered(), (Object)"searchPlatform", (Object)this.searchPlatformConfig.searchPlatform().getFriendlyName());
        this.soyTemplateRenderer.render((Appendable)response.getWriter(), RESOURCE_KEY, TEMPLATE_KEY, (Map)data);
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        URI uri = this.getUri(request);
        response.sendRedirect(this.loginUriProvider.getLoginUri(uri).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        if (request.getQueryString() != null) {
            requestURL.append("?").append(request.getQueryString());
        }
        return URI.create(requestURL.toString());
    }
}

