/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.rebuildindex.status;

import com.atlassian.confluence.index.status.ReIndexJob;
import com.atlassian.confluence.index.status.ReIndexStage;
import com.atlassian.confluence.index.status.ReindexType;
import com.atlassian.confluence.plugins.rebuildindex.status.ReIndexNodeStatusJson;
import com.atlassian.confluence.search.ReIndexOption;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonSerialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ReIndexJobJson {
    private final String id;
    private final Long startTime;
    private final Long finishTime;
    private final Long duration;
    private final ReIndexStage stage;
    private final boolean acknowledged;
    private final long progress;
    private final Collection<ReIndexNodeStatusJson> nodeStatuses;
    private String createdBy;
    private ReindexType type;
    private final Collection<ReIndexOption> reIndexOptions;

    @JsonCreator
    public ReIndexJobJson(@JsonProperty(value="id") String id, @JsonProperty(value="startTime") Long startTime, @JsonProperty(value="completeTime") Long finishTime, @JsonProperty(value="duration") Long duration, @JsonProperty(value="stage") ReIndexStage stage, @JsonProperty(value="acknowledged") boolean acknowledged, @JsonProperty(value="progress") long progress, @JsonProperty(value="nodes") Collection<ReIndexNodeStatusJson> nodeStatuses, @JsonProperty(value="createdBy") String createdBy, @JsonProperty(value="contentTypes") Collection<ReIndexOption> reIndexOptions, @JsonProperty(value="type") ReindexType type) {
        this.id = id;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.duration = duration;
        this.stage = stage;
        this.acknowledged = acknowledged;
        this.reIndexOptions = new ArrayList<ReIndexOption>(reIndexOptions);
        this.progress = progress;
        this.nodeStatuses = new ArrayList<ReIndexNodeStatusJson>(nodeStatuses);
        this.createdBy = createdBy;
        this.type = type;
    }

    public ReIndexJobJson(ReIndexJob reIndexJob) {
        this.id = reIndexJob.getId();
        this.startTime = reIndexJob.getStartTime().getEpochSecond();
        Instant finishTime = reIndexJob.getFinishTime();
        this.finishTime = finishTime != null ? Long.valueOf(finishTime.getEpochSecond()) : null;
        Duration duration = reIndexJob.getDuration();
        this.duration = duration.toSeconds();
        this.stage = reIndexJob.getStage();
        this.acknowledged = reIndexJob.isAcknowledged();
        Optional.ofNullable(reIndexJob.getCreatedBy()).ifPresent(user -> {
            this.createdBy = user.getFullName();
        });
        this.progress = reIndexJob.getProgressPercentage();
        this.nodeStatuses = reIndexJob.getNodeStatuses().stream().map(ReIndexNodeStatusJson::new).collect(Collectors.toList());
        this.reIndexOptions = reIndexJob.getReIndexOptions().stream().map(reIndexOption -> ReIndexOption.valueOf((String)reIndexOption.toString())).collect(Collectors.toList());
        this.type = CollectionUtils.isEmpty((Collection)reIndexJob.getSpaceKeys()) ? ReindexType.SITE : ReindexType.SPACE;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="startTime")
    public Long getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="completeTime")
    public @Nullable Long getFinishTime() {
        return this.finishTime;
    }

    @JsonProperty(value="duration")
    public Long getDuration() {
        return this.duration;
    }

    @JsonProperty(value="stage")
    public ReIndexStage getStage() {
        return this.stage;
    }

    @JsonProperty(value="acknowledged")
    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    @JsonProperty(value="progress")
    public long getProgress() {
        return this.progress;
    }

    @JsonProperty(value="nodes")
    public Collection<ReIndexNodeStatusJson> getNodeStatuses() {
        return this.nodeStatuses;
    }

    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="type")
    public ReindexType getType() {
        return this.type;
    }

    @JsonProperty(value="reIndexOptions")
    public Collection<ReIndexOption> getReIndexOptions() {
        return this.reIndexOptions;
    }
}

