/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.rest.one.zero.model;

import com.atlassian.webresource.api.assembler.resource.PluginCssResource;
import com.atlassian.webresource.api.assembler.resource.PluginJsResource;
import com.atlassian.webresource.plugin.async.model.ResourceTypeAndUrl;
import com.atlassian.webresource.plugin.rest.one.zero.model.Resource;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(alphabetic=true)
public class ResourcesAndData {
    @Nonnull
    public final List<Resource> resources;
    @Nonnull
    public final Map<String, String> unparsedData;
    @Nonnull
    public final Map<String, String> unparsedErrors;

    public ResourcesAndData(@Nonnull com.atlassian.webresource.plugin.async.model.ResourcesAndData resourcesAndData) {
        ResourcesAndData convertedResourcesAndData = ResourcesAndData.convert(resourcesAndData);
        this.resources = convertedResourcesAndData.resources;
        this.unparsedData = convertedResourcesAndData.unparsedData;
        this.unparsedErrors = convertedResourcesAndData.unparsedErrors;
    }

    @JsonCreator
    public ResourcesAndData(@Nonnull @JsonProperty(value="resources") List<Resource> resources, @Nonnull @JsonProperty(value="unparsedData") Map<String, String> unparsedData, @Nonnull @JsonProperty(value="unparsedErrors") Map<String, String> unparsedErrors) {
        this.resources = resources;
        this.unparsedData = new HashMap<String, String>(unparsedData);
        this.unparsedErrors = new HashMap<String, String>(unparsedErrors);
    }

    @Nonnull
    @JsonProperty(value="resources")
    public List<Resource> getResources() {
        return this.resources;
    }

    @Nonnull
    @JsonProperty(value="unparsedData")
    public Map<String, String> getUnparsedData() {
        return this.unparsedData;
    }

    @Nonnull
    @JsonProperty(value="unparsedErrors")
    public Map<String, String> getUnparsedErrors() {
        return this.unparsedErrors;
    }

    private static ResourcesAndData convert(com.atlassian.webresource.plugin.async.model.ResourcesAndData resourcesAndData) {
        Iterable resources = Stream.of(resourcesAndData.getRequireResources(), resourcesAndData.getResourcesForInteration()).flatMap(Collection::stream).map(ResourceTypeAndUrl::getPluginUrlResource).filter(resource -> resource instanceof PluginJsResource || resource instanceof PluginCssResource).map(webResource -> {
            if (webResource instanceof PluginJsResource) {
                return new Resource((PluginJsResource)webResource);
            }
            return new Resource((PluginCssResource)webResource);
        }).collect(Collectors.toCollection(ArrayList::new));
        Map<String, String> unparsedData = Stream.of(resourcesAndData.getRequiredResourcesUnparsedData(), resourcesAndData.getResourcesForInterationUnparsedData()).flatMap(data -> data.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> unparsedErrors = Stream.of(resourcesAndData.getRequireResourcesUnparsedErrors(), resourcesAndData.getResourcesForInterationUnparsedErrors()).flatMap(data -> data.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new ResourcesAndData(StreamSupport.stream(resources.spliterator(), false).collect(Collectors.toList()), unparsedData, unparsedErrors);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ResourcesAndData) {
            ResourcesAndData otherResourcesAndData = (ResourcesAndData)other;
            return Objects.equals(this.resources, otherResourcesAndData.resources) && Objects.equals(this.unparsedData, otherResourcesAndData.unparsedData) && Objects.equals(this.unparsedErrors, otherResourcesAndData.unparsedErrors);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.resources, this.unparsedData, this.unparsedErrors);
    }

    public String toString() {
        return "ResourcesAndData{resources=" + String.valueOf(this.resources) + ", unparsedData=" + String.valueOf(this.unparsedData) + ", unparsedErrors=" + String.valueOf(this.unparsedErrors) + "}";
    }
}

