/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.enrich;

import com.atlassian.confluence.plugins.restapi.enrich.AbstractLinkEnricher;
import com.atlassian.confluence.plugins.restapi.enrich.CollectionEnricher;
import com.atlassian.confluence.plugins.restapi.enrich.EntityEnricher;
import com.atlassian.confluence.rest.serialization.jackson2.enrich.SchemaType;
import com.atlassian.confluence.rest.v2.api.graphql.GraphQL;
import com.atlassian.confluence.rest.v2.api.model.RestEntity;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestObject;
import com.atlassian.confluence.rest.v2.api.services.RestNavigationService;
import java.lang.reflect.Type;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

class BaseLinkEnricher
extends AbstractLinkEnricher
implements EntityEnricher,
CollectionEnricher {
    private static final String BASE_LINK = "base";
    private static final String CONTEXT_PATH = "context";

    public BaseLinkEnricher(RestNavigationService navBuilderService, GraphQL graphql) {
        super(navBuilderService, graphql);
    }

    @Override
    public boolean isRecursive() {
        return false;
    }

    @Override
    public @NonNull Map<String, Type> getEnrichedPropertyTypes(@NonNull Type type) {
        return super.getEnrichedPropertyTypes(BASE_LINK, CONTEXT_PATH);
    }

    @Override
    public void enrich(@NonNull RestEntity entity, @NonNull SchemaType schemaType) {
        this.enrichObject((RestObject)entity, schemaType);
    }

    @Override
    public void enrich(@NonNull RestList enrich, @NonNull SchemaType schemaType) {
        this.enrichObject((RestObject)enrich, schemaType);
    }

    private void enrichObject(RestObject enrich, SchemaType schemaType) {
        this.enrichWithBaseLink(enrich, schemaType);
        this.enrichWithContextPath(enrich, schemaType);
    }

    private void enrichWithBaseLink(RestObject entity, SchemaType schemaType) {
        this.enrichWithLink(entity, BASE_LINK, this.navigation().baseUrl(), schemaType);
    }

    private void enrichWithContextPath(RestObject entity, SchemaType schemaType) {
        this.enrichWithLink(entity, CONTEXT_PATH, this.navigation().contextPath(), schemaType);
    }
}

