/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.enrich;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.plugins.restapi.enrich.AbstractLinkEnricher;
import com.atlassian.confluence.plugins.restapi.enrich.CollectionEnricher;
import com.atlassian.confluence.plugins.restapi.graphql.ReflectionUtil;
import com.atlassian.confluence.rest.serialization.jackson2.enrich.SchemaType;
import com.atlassian.confluence.rest.v2.api.graphql.GraphQL;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestObject;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.confluence.rest.v2.api.services.RestNavigationService;
import jakarta.ws.rs.core.UriBuilder;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

class SelfLinkCollectionEnricher
extends AbstractLinkEnricher
implements CollectionEnricher {
    public SelfLinkCollectionEnricher(RestNavigationService navService, GraphQL graphql) {
        super(navService, graphql);
    }

    @Override
    public boolean isRecursive() {
        return true;
    }

    @Override
    public @NonNull Map<String, Type> getEnrichedPropertyTypes(@NonNull Type type) {
        if (PageRequest.class.isAssignableFrom(ReflectionUtil.getClazz(type))) {
            return super.getEnrichedPropertyTypes("self");
        }
        return Collections.emptyMap();
    }

    @Override
    public void enrich(@NonNull RestList enrich, @NonNull SchemaType schemaType) {
        PageRequest request = enrich.getPageRequest();
        if (request instanceof RestPageRequest) {
            RestPageRequest restPageRequest = (RestPageRequest)request;
            UriBuilder builder = UriBuilder.fromUri((URI)restPageRequest.getRequestUri()).replaceQueryParam("limit", new Object[0]).replaceQueryParam("start", new Object[0]);
            this.enrichWithLink((RestObject)enrich, "self", this.navigation().fromUriBuilder(builder).buildCanonicalAbsolute(), schemaType);
        }
    }
}

