/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.enrich;

import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.plugins.restapi.enrich.EntityEnricher;
import com.atlassian.confluence.rest.serialization.jackson2.enrich.SchemaType;
import com.atlassian.confluence.rest.v2.api.model.RestEntity;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

final class TimestampEntityEnricher
implements EntityEnricher {
    private static final String TIMESTAMP_PROPERTY = "timestamp";

    TimestampEntityEnricher() {
    }

    @Override
    public boolean isRecursive() {
        return true;
    }

    @Override
    public @NonNull Map<String, Type> getEnrichedPropertyTypes(@NonNull Type type) {
        return Collections.emptyMap();
    }

    @Override
    public void enrich(@NonNull RestEntity entity, @NonNull SchemaType schemaType) {
        Object delegate = entity.getDelegate();
        if (delegate instanceof SearchResult) {
            SearchResult searchResult = (SearchResult)delegate;
            entity.putProperty(TIMESTAMP_PROPERTY, (Object)searchResult.getLastModifiedAt().toInstant().toEpochMilli());
        }
    }
}

