/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.api;

import com.atlassian.streams.api.common.Functions;
import com.atlassian.streams.api.common.Option;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Html
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Html.class);
    private final String value;

    public Html(String value) {
        this.value = this.stripControlChars((String)Preconditions.checkNotNull((Object)value));
    }

    @Deprecated
    public static Html html(String s) {
        return new Html(s);
    }

    public static Option<Html> trimHtml2None(Html h) {
        return Functions.trimToNone(h.toString()).map(Html::new);
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Html other = (Html)obj;
        return this.value.equals(other.value);
    }

    private String stripControlChars(String s) {
        StringBuilder sb = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (this.illegal(c)) {
                log.debug("Invalid character encountered: codePoint = {}", (Object)String.valueOf(c).codePointAt(0));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private boolean illegal(char c) {
        return this.between(c, '\u0000', '\b') || this.between(c, '\u000b', '\u001f') || this.between(c, '\ufffe', '\uffff');
    }

    private boolean between(char c, char minInclusive, char maxInclusive) {
        return c >= minInclusive && c <= maxInclusive;
    }
}

