/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.api.common;

import com.atlassian.streams.api.common.NonEmptyIterable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ImmutableNonEmptyList<T>
implements List<T>,
NonEmptyIterable<T> {
    private final ImmutableList<T> delegate;

    public ImmutableNonEmptyList(T head) {
        Preconditions.checkNotNull(head, (Object)"head");
        this.delegate = ImmutableList.of(head);
    }

    public ImmutableNonEmptyList(T head, Iterable<T> tail) {
        Preconditions.checkNotNull(head, (Object)"head");
        this.delegate = ImmutableList.builder().add(head).addAll(tail).build();
    }

    public ImmutableNonEmptyList(NonEmptyIterable<T> items) {
        Preconditions.checkNotNull(items, (Object)"items");
        this.delegate = ImmutableList.copyOf(items);
    }

    public static <E> ImmutableNonEmptyList<E> of(E e) {
        return new ImmutableNonEmptyList<E>(e);
    }

    public static <E> ImmutableNonEmptyList<E> of(E e1, E e2) {
        return new ImmutableNonEmptyList<E>(e1, ImmutableList.of(e2));
    }

    public static <E> ImmutableNonEmptyList<E> of(E e, E ... others) {
        return new ImmutableNonEmptyList<E>(e, Arrays.asList(others));
    }

    public static <E> ImmutableNonEmptyList<E> of(E e, Iterable<E> others) {
        return new ImmutableNonEmptyList<E>(e, others);
    }

    public static <E> ImmutableNonEmptyList<E> copyOf(NonEmptyIterable<E> items) {
        return items instanceof ImmutableNonEmptyList ? (ImmutableNonEmptyList<Object>)items : new ImmutableNonEmptyList<E>(items);
    }

    @Override
    public boolean add(T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends T> elements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, @Nonnull Collection<? extends T> elements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        return this.delegate.contains(object);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> collection) {
        return this.delegate.containsAll(collection);
    }

    @Override
    public T get(int index) {
        return (T)this.delegate.get(index);
    }

    @Override
    public int indexOf(@CheckForNull Object element) {
        return this.delegate.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int lastIndexOf(@CheckForNull Object element) {
        return this.delegate.lastIndexOf(element);
    }

    @Override
    @Nonnull
    public ListIterator<T> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    @Nonnull
    public ListIterator<T> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> elements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> elements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    @Nonnull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    @Nonnull
    public <U> U[] toArray(@Nonnull U[] array) {
        return this.delegate.toArray((Object[])array);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        return object == this || this.delegate.equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }
}

