/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.api.common;

import com.atlassian.streams.api.common.Fold;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public final class Pairs {
    public static <A> Iterable<Pair<A, A>> mkPairs(Iterable<A> xs) {
        return (Iterable)Fold.foldl(xs, Pair.pair(ImmutableList.of(), Option.none()), Pairs.mkPairs()::apply).first();
    }

    private static <A> BiFunction<A, Pair<Iterable<Pair<A, A>>, Option<A>>, Pair<Iterable<Pair<A, A>>, Option<A>>> mkPairs() {
        return new MkPairs();
    }

    public static <A, B> Iterable<A> firsts(Iterable<Pair<A, B>> pairs) {
        return Iterables.transform(pairs, Pair::first);
    }

    public static <A, B> Predicate<Pair<A, B>> withFirst(final Predicate<A> p) {
        return new Predicate<Pair<A, B>>(){

            @Override
            public boolean test(Pair<A, B> pair) {
                return p.test(pair.first());
            }

            public String toString() {
                return String.format("withFirst(%s)", p);
            }
        };
    }

    public static <A, B> Predicate<Pair<A, B>> withSecond(final Predicate<B> p) {
        return new Predicate<Pair<A, B>>(){

            @Override
            public boolean test(Pair<A, B> pair) {
                return p.test(pair.second());
            }

            public String toString() {
                return String.format("withSecond(%s)", p);
            }
        };
    }

    private static final class MkPairs<A>
    implements BiFunction<A, Pair<Iterable<Pair<A, A>>, Option<A>>, Pair<Iterable<Pair<A, A>>, Option<A>>> {
        private MkPairs() {
        }

        @Override
        public Pair<Iterable<Pair<A, A>>, Option<A>> apply(A v, Pair<Iterable<Pair<A, A>>, Option<A>> intermediate) {
            Iterator<A> iterator = intermediate.second().iterator();
            if (iterator.hasNext()) {
                A a = iterator.next();
                return Pair.pair(Iterables.concat(intermediate.first(), (Iterable)ImmutableList.of(Pair.pair(a, v))), Option.none());
            }
            return Pair.pair(intermediate.first(), Option.some(v));
        }
    }
}

