/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pats.checker;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pats.checker.ActiveUserNotFoundException;
import com.atlassian.pats.checker.ProductUserProvider;
import com.atlassian.sal.api.user.UserKey;
import java.security.Principal;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraProductUserProvider
implements ProductUserProvider {
    private static final Logger logger = LoggerFactory.getLogger(JiraProductUserProvider.class);
    private final UserKeyService userKeyService;
    private final UserManager userManager;

    public JiraProductUserProvider(UserKeyService userKeyService, UserManager userManager) {
        this.userKeyService = userKeyService;
        this.userManager = userManager;
    }

    @Override
    @Nonnull
    public Optional<? extends Principal> getActiveUserByKey(@Nonnull UserKey userkey) {
        logger.debug("Looking for Jira user with key: [{}]", (Object)userkey);
        return Optional.ofNullable(this.userManager.getUserByKey(userkey.getStringValue())).filter(ApplicationUser::isActive);
    }

    @Override
    public boolean isUserDeleted(@Nonnull String userKey) throws ActiveUserNotFoundException {
        return !this.getActiveUserByKey(new UserKey(userKey)).isPresent();
    }

    @Override
    @Nonnull
    public Optional<UserKey> getKeyForUsername(@Nonnull String username) {
        return Optional.ofNullable(this.userKeyService.getKeyForUsername(username)).map(UserKey::new);
    }
}

