/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pats.config;

import com.atlassian.audit.api.AuditService;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.pats.access.services.ConfluenceReadOnlyModeService;
import com.atlassian.pats.access.services.ReadOnlyModeService;
import com.atlassian.pats.checker.ConfluenceProductUserProvider;
import com.atlassian.pats.checker.ProductUserProvider;
import com.atlassian.pats.entrypoint.ConfluenceProfilePersonalAccessTokenView;
import com.atlassian.pats.events.audit.AuditLogHandler;
import com.atlassian.pats.events.audit.confluence.ConfluenceAdvancedAuditLogHandler;
import com.atlassian.pats.notifications.mail.services.ConfluenceMailService;
import com.atlassian.pats.notifications.mail.services.ProductMailService;
import com.atlassian.pats.utils.ConfluenceHelper;
import com.atlassian.pats.utils.ProductHelper;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.ConfluenceOnly;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={ConfluenceOnly.class})
public class ConfluencePersonalTokenConfig {
    @Bean
    public AbstractUserProfileAction confluenceProfilePersonalAccessTokenView() {
        return new ConfluenceProfilePersonalAccessTokenView();
    }

    @Bean
    public UserAccessor searchManager() {
        return OsgiServices.importOsgiService(UserAccessor.class);
    }

    @Bean
    public ProductUserProvider userProvider(UserAccessor userAccessor) {
        return new ConfluenceProductUserProvider(userAccessor);
    }

    @Bean
    public MultiQueueTaskManager multiQueueTaskManager() {
        return OsgiServices.importOsgiService(MultiQueueTaskManager.class);
    }

    @Bean
    public ProductMailService productMailService(MultiQueueTaskManager multiQueueTaskManager) {
        return new ConfluenceMailService(multiQueueTaskManager);
    }

    @Bean
    public ProductHelper productHelper(ApplicationProperties applicationProperties, I18nResolver i18nResolver) {
        return new ConfluenceHelper(applicationProperties, i18nResolver);
    }

    @Bean
    public AuditService auditService() {
        return OsgiServices.importOsgiService(AuditService.class);
    }

    @Bean
    public AuditLogHandler auditLogHandler(I18nResolver i18nResolver, UserAccessor userAccessor, AuditService auditService) {
        return new ConfluenceAdvancedAuditLogHandler(auditService, i18nResolver, userAccessor);
    }

    @Bean
    public AccessModeService accessModeService() {
        return OsgiServices.importOsgiService(AccessModeService.class);
    }

    @Bean
    public ReadOnlyModeService readOnlyModeService(AccessModeService accessModeService) {
        return new ConfluenceReadOnlyModeService(accessModeService);
    }
}

