/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pats.entrypoint;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnlicensedSiteAccess
public class JiraServiceManagementProfilePersonalAccessTokenServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(JiraServiceManagementProfilePersonalAccessTokenServlet.class);
    private final SoyTemplateRenderer renderer;

    public JiraServiceManagementProfilePersonalAccessTokenServlet(SoyTemplateRenderer renderer) {
        this.renderer = renderer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isInCustomerContext()) {
            response.setContentType("text/html");
            this.renderer.render((Appendable)response.getWriter(), "com.atlassian.pats.pats-plugin:jsm-personal-access-tokens-plugin-frontend-templates", "Personal.Access.Tokens.Display", Collections.emptyMap());
        } else {
            response.sendError(403);
        }
    }

    @VisibleForTesting
    boolean isInCustomerContext() {
        try {
            return Optional.ofNullable((CustomerContextService)ComponentAccessor.getOSGiComponentInstanceOfType(CustomerContextService.class)).map(CustomerContextService::isInCustomerContext).orElse(false);
        }
        catch (Exception e) {
            logger.error("Failed to determine if in customer context", (Throwable)e);
            return false;
        }
    }
}

