/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.namemapping;

import com.querydsl.sql.SchemaAndTable;
import com.querydsl.sql.namemapping.NameMapping;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PreConfiguredNameMapping
implements NameMapping {
    private final Map<SchemaAndTable, SchemaAndTable> schemaTables = new HashMap<SchemaAndTable, SchemaAndTable>();
    private final Map<String, String> tables = new HashMap<String, String>();
    private final Map<SchemaAndTable, Map<String, String>> schemaTableColumns = new HashMap<SchemaAndTable, Map<String, String>>();
    private final Map<String, Map<String, String>> tableColumns = new HashMap<String, Map<String, String>>();

    @Override
    public Optional<SchemaAndTable> getOverride(SchemaAndTable key) {
        if (!this.schemaTables.isEmpty() && key.getSchema() != null && this.schemaTables.containsKey(key)) {
            return Optional.ofNullable(this.schemaTables.get(key));
        }
        if (this.tables.containsKey(key.getTable())) {
            String table = this.tables.get(key.getTable());
            return Optional.of(new SchemaAndTable(key.getSchema(), table));
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getColumnOverride(SchemaAndTable key, String column) {
        String newColumn = null;
        Map<String, String> columnOverrides = this.schemaTableColumns.get(key);
        if (columnOverrides != null && (newColumn = columnOverrides.get(column)) != null) {
            return Optional.of(newColumn);
        }
        columnOverrides = this.tableColumns.get(key.getTable());
        if (columnOverrides != null && (newColumn = columnOverrides.get(column)) != null) {
            return Optional.of(newColumn);
        }
        return Optional.empty();
    }

    public String registerTableOverride(String oldTable, String newTable) {
        return this.tables.put(oldTable, newTable);
    }

    public SchemaAndTable registerTableOverride(SchemaAndTable from, SchemaAndTable to) {
        return this.schemaTables.put(from, to);
    }

    public String registerColumnOverride(String schema, String table, String oldColumn, String newColumn) {
        SchemaAndTable key = new SchemaAndTable(schema, table);
        Map columnOverrides = this.schemaTableColumns.computeIfAbsent(key, k -> new HashMap());
        return columnOverrides.put(oldColumn, newColumn);
    }

    public String registerColumnOverride(String table, String oldColumn, String newColumn) {
        Map columnOverrides = this.tableColumns.computeIfAbsent(table, k -> new HashMap());
        return columnOverrides.put(oldColumn, newColumn);
    }
}

