/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.ipd.api;

import com.atlassian.diagnostics.ipd.api.MeterConfigurations;
import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfigBuilder;
import com.atlassian.diagnostics.ipd.api.meters.config.ProductMeterConfigBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class MeterConfigurationsImpl
implements MeterConfigurations {
    private final PrefixNode rootPrefixTrieNode = new PrefixNode();
    private final Consumer<ProductMeterConfigBuilder> defaultConfig;

    public MeterConfigurationsImpl(Consumer<ProductMeterConfigBuilder> defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    @Override
    public MeterConfigurations addMeterConfig(String prefixMatcher, Consumer<MeterConfigBuilder> meterConfig) {
        this.rootPrefixTrieNode.setMeterConfig(prefixMatcher, meterConfig);
        return this;
    }

    @Override
    public void evaluateConfig(MeterKey meterKey, ProductMeterConfigBuilder configBuilder) {
        this.defaultConfig.accept(configBuilder);
        this.rootPrefixTrieNode.evaluateConfig(meterKey.getName(), configBuilder);
    }

    private static class PrefixNode {
        private final AtomicReference<Consumer<MeterConfigBuilder>> meterConfig = new AtomicReference<Object>(null);
        private final Map<String, PrefixNode> children = new ConcurrentHashMap<String, PrefixNode>();

        private PrefixNode() {
        }

        public void setMeterConfig(String prefix, Consumer<MeterConfigBuilder> meterConfig) {
            if (prefix.isEmpty()) {
                this.meterConfig.set(meterConfig);
            } else {
                this.children.computeIfAbsent(this.getFirstSegment(prefix), ignored -> new PrefixNode()).setMeterConfig(this.removeFirstSegment(prefix), meterConfig);
            }
        }

        public void evaluateConfig(String prefix, MeterConfigBuilder configBuilder) {
            Consumer<MeterConfigBuilder> currentConfig = this.meterConfig.get();
            if (currentConfig != null) {
                currentConfig.accept(configBuilder);
            }
            if (prefix.isEmpty()) {
                return;
            }
            PrefixNode child = this.children.get(this.getFirstSegment(prefix));
            if (child != null) {
                child.evaluateConfig(this.removeFirstSegment(prefix), configBuilder);
            }
        }

        private String removeFirstSegment(String prefix) {
            int index = prefix.indexOf(46);
            if (index == -1) {
                return "";
            }
            return prefix.substring(index + 1);
        }

        private String getFirstSegment(String prefix) {
            int index = prefix.indexOf(46);
            if (index == -1) {
                return prefix;
            }
            return prefix.substring(0, index);
        }
    }
}

