/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.ipd.api;

import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MeterKey {
    private final String name;
    private final MeterTag[] tags;
    private final Map<String, String> tagsMap;
    private final Map<String, String> formattedTagsMap;

    public MeterKey(String name, MeterTag ... tags) {
        this.name = name;
        this.tags = tags;
        this.tagsMap = ImmutableMap.copyOf(Arrays.stream(tags).collect(Collectors.toMap(MeterTag::getKey, MeterTag::getValue)));
        this.formattedTagsMap = ImmutableMap.copyOf(Arrays.stream(tags).map(MeterTag::getFormattedTag).collect(Collectors.toMap(MeterTag::getKey, MeterTag::getValue)));
    }

    public String getName() {
        return this.name;
    }

    public MeterTag[] getTags() {
        return this.tags;
    }

    public Map<String, String> getTagsAsMap() {
        return this.tagsMap;
    }

    public Map<String, String> getFormattedTagsAsMap() {
        return this.formattedTagsMap;
    }

    @Nullable
    public String getTag(String key) {
        for (MeterTag tag : this.tags) {
            if (!tag.getKey().equals(key)) continue;
            return tag.getValue();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeterKey meterKey = (MeterKey)o;
        return Objects.equals(this.name, meterKey.name) && Arrays.equals(this.tags, meterKey.tags);
    }

    public int hashCode() {
        int result = Objects.hash(this.name);
        result = 31 * result + Arrays.hashCode(this.tags);
        return result;
    }

    public String toString() {
        return "MeterKey{name='" + this.name + "', tags=" + Arrays.toString(this.tags) + "}";
    }
}

