/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.ipd.api.meters.config;

import com.atlassian.diagnostics.ipd.api.IpdConstants;
import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.meters.IpdMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfigBuilder;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterObjectNameConstructor;
import com.atlassian.diagnostics.ipd.api.meters.config.ProductMeterConfigBuilder;
import java.time.Clock;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;

public class MeterConfigBuilderImpl
implements ProductMeterConfigBuilder {
    final Map<String, Object> properties = new HashMap<String, Object>();
    Predicate<MeterConfig> enabledCheck = IpdConstants.TRUE_CONFIG_PREDICATE;
    Consumer<IpdMeter> updateListener = IpdConstants.NO_OP;
    MeterObjectNameConstructor objectNameFactory = MeterConfigBuilderImpl::defaultTestObjectNameConstructor;
    Predicate<IpdMeter> shouldLog = IpdConstants.TRUE_METER_PREDICATE;
    Logger logger = IpdConstants.DEFAULT_DATA_LOGGER;

    @Override
    public ProductMeterConfigBuilder setObjectNameConstructor(MeterObjectNameConstructor objectNameFactory) {
        this.objectNameFactory = objectNameFactory;
        return this;
    }

    @Override
    public MeterConfigBuilderImpl setUpdateListener(Consumer<IpdMeter> updateListener) {
        this.updateListener = updateListener;
        return this;
    }

    @Override
    public MeterConfigBuilder addEnabledCheck(Predicate<MeterConfig> enabledCheck) {
        this.enabledCheck = this.enabledCheck.and(enabledCheck);
        return this;
    }

    @Override
    public MeterConfigBuilder setProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public MeterConfigBuilder setWorkInProgress(boolean workInProgress) {
        this.setProperty("workInProgress", workInProgress);
        return this;
    }

    @Override
    public MeterConfigBuilder logOnceEveryInterval(int interval) {
        AtomicInteger counter = new AtomicInteger(0);
        return this.logWhen(m -> counter.incrementAndGet() % interval == 0);
    }

    @Override
    public MeterConfigBuilder logIfUpdatedInLastMinute() {
        Clock clock = Optional.ofNullable(this.properties.get("customClock")).map(Clock.class::cast).orElse(Clock.systemUTC());
        return this.logWhen(m -> clock.millis() - m.lastUpdateMillis() < 60000L);
    }

    @Override
    public MeterConfigBuilder setCustomLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    @Override
    public MeterConfigBuilder setIntervalLogging(boolean enabled) {
        this.properties.put("intervalLogging", enabled);
        return this;
    }

    @Override
    public MeterConfigBuilder setLogOnUpdate(boolean logOnUpdate) {
        this.properties.put("logOnUpdate", logOnUpdate);
        return this;
    }

    @Override
    public MeterConfigBuilder logWhen(Predicate<IpdMeter> shouldLog) {
        this.shouldLog = this.shouldLog.and(shouldLog);
        return this;
    }

    @Override
    public MeterConfig build(MeterKey meterKey) {
        return new MeterConfig(meterKey, this);
    }

    private static ObjectName defaultTestObjectNameConstructor(MeterKey meterKey) {
        String tags = Arrays.stream(meterKey.getTags()).map(MeterTag::toString).collect(Collectors.joining(","));
        String name = "com.atlassian.diagnostics:meterKeyProperty=" + meterKey.getName() + (String)(tags.isEmpty() ? "" : "," + tags);
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("ObjectName: " + name, e);
        }
    }
}

