/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.ipd.api.meters.custom.type;

import com.atlassian.diagnostics.ipd.api.meters.CustomMeter;
import com.atlassian.diagnostics.ipd.api.meters.custom.type.IpdBucketsCounterMxBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IpdLongBucketsCounter
implements IpdBucketsCounterMxBean {
    private static final Long[] MAX_LONG = new Long[]{Long.MAX_VALUE};
    private final Map<Long, AtomicLong> bucketsMap;
    private final Long[] buckets;

    public IpdLongBucketsCounter(Long ... buckets) {
        this.buckets = (Long[])Arrays.stream(buckets).sorted().toArray(Long[]::new);
        this.bucketsMap = Stream.of(this.buckets, MAX_LONG).flatMap(Arrays::stream).collect(Collectors.toUnmodifiableMap(b -> b, b -> new AtomicLong()));
    }

    public void putValue(long value) {
        Long[] longArray = this.buckets;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long bucket = longArray[i];
            if (value >= bucket) continue;
            this.bucketsMap.get(bucket).incrementAndGet();
            return;
        }
        this.bucketsMap.get(Long.MAX_VALUE).incrementAndGet();
    }

    public void reset() {
        for (AtomicLong bucket : this.bucketsMap.values()) {
            bucket.set(0L);
        }
    }

    @Override
    public Map<String, Long> getBuckets() {
        return Collections.unmodifiableMap(this.bucketsMap.entrySet().stream().collect(Collectors.toMap(entry -> {
            if ((Long)entry.getKey() == Long.MAX_VALUE) {
                return "MAX";
            }
            return ((Long)entry.getKey()).toString();
        }, e -> ((AtomicLong)e.getValue()).get())));
    }

    public static LongBucketsDefinition buckets(Long ... buckets) {
        return new LongBucketsDefinition(buckets);
    }

    public static class LongBucketsDefinition
    extends CustomMeter.MBeanSupplier<IpdLongBucketsCounter> {
        private LongBucketsDefinition(Long ... buckets) {
            super(IpdLongBucketsCounter.class, () -> new IpdLongBucketsCounter(buckets));
        }
    }
}

