/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.ipd.api.meters.custom.type;

import com.atlassian.diagnostics.ipd.api.meters.CustomMeter;
import com.atlassian.diagnostics.ipd.api.meters.custom.type.IpdBucketsCounterMxBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class IpdStringBucketsCounter
implements IpdBucketsCounterMxBean {
    private final Map<String, AtomicLong> bucketsMap;

    public IpdStringBucketsCounter(String ... buckets) {
        this.bucketsMap = Arrays.stream(buckets).collect(Collectors.toUnmodifiableMap(b -> b, b -> new AtomicLong()));
    }

    public void increment(@Nonnull String value) {
        AtomicLong counter = this.bucketsMap.get(value);
        if (counter != null) {
            counter.incrementAndGet();
        }
    }

    public void reset() {
        for (AtomicLong bucket : this.bucketsMap.values()) {
            bucket.set(0L);
        }
    }

    @Override
    public Map<String, Long> getBuckets() {
        return Collections.unmodifiableMap(this.bucketsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AtomicLong)e.getValue()).get())));
    }

    public static StringBucketsDefinition buckets(String ... buckets) {
        return new StringBucketsDefinition(buckets);
    }

    public static class StringBucketsDefinition
    extends CustomMeter.MBeanSupplier<IpdStringBucketsCounter> {
        private StringBucketsDefinition(String ... buckets) {
            super(IpdStringBucketsCounter.class, () -> new IpdStringBucketsCounter(buckets));
        }
    }
}

