/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.ipd.api.registry;

import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.meters.CounterMeter;
import com.atlassian.diagnostics.ipd.api.meters.CustomMeter;
import com.atlassian.diagnostics.ipd.api.meters.IpdMeter;
import com.atlassian.diagnostics.ipd.api.meters.JmxCopyMeter;
import com.atlassian.diagnostics.ipd.api.meters.StatsMeter;
import com.atlassian.diagnostics.ipd.api.meters.ValueAndStatsMeterWrapper;
import com.atlassian.diagnostics.ipd.api.meters.ValueMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterFactory;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.management.ObjectName;

public interface IpdRegistry {
    public <T extends IpdMeter> T register(MeterFactory<T> var1, String var2, MeterTag ... var3);

    @Nullable
    public IpdMeter get(MeterKey var1);

    public Collection<IpdMeter> getMeters();

    public Collection<IpdMeter> getMeters(String var1);

    public Set<MeterKey> getMeterKeys();

    public Set<MeterKey> getMeterKeys(String var1);

    public void unregisterAllDisabledMetrics();

    public void remove(MeterKey var1);

    public void removeAll();

    public void removeAll(String var1, MeterTag ... var2);

    public void removeAllWithAnyTag(String var1, Set<MeterTag> var2);

    public void removeIf(Predicate<IpdMeter> var1);

    public void removeIf(String var1, Predicate<IpdMeter> var2);

    public void retainIf(String var1, Predicate<IpdMeter> var2);

    default public ValueAndStatsMeterWrapper valueAndStats(String name, MeterTag ... tags) {
        return new ValueAndStatsMeterWrapper(this.stats(name, tags), this.value(name, tags));
    }

    public ValueMeter value(String var1, MeterTag ... var2);

    default public void setValue(String name, long value, MeterTag ... tags) {
        this.value(name, tags).update(value);
    }

    public StatsMeter stats(String var1, MeterTag ... var2);

    default public void addStats(String name, long value, MeterTag ... tags) {
        this.stats(name, tags).update(value);
    }

    default public void addStats(String name, long value, TimeUnit timeUnit, MeterTag ... tags) {
        this.stats(name, tags).update(value, timeUnit);
    }

    public CounterMeter counter(String var1, MeterTag ... var2);

    default public void incrementCounter(String name, MeterTag ... tags) {
        this.counter(name, tags).increment(1L);
    }

    public <T> CustomMeter<T> custom(String var1, Class<T> var2, MeterTag ... var3);

    public <T> CustomMeter<T> custom(String var1, CustomMeter.MBeanSupplier<T> var2, MeterTag ... var3);

    public JmxCopyMeter statsCopy(String var1, ObjectName var2, MeterTag ... var3);

    public void shutdown();
}

