/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache.caffeine;

import com.atlassian.cache.CacheSettings;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CaffeineBuilder {
    private static final Logger log = LoggerFactory.getLogger(CaffeineBuilder.class);

    CaffeineBuilder() {
    }

    static <K, V> Cache<K, V> create(String name, CacheSettings settings) {
        log.warn("Creating new Caffeine backing cache for [{}]", (Object)name);
        Caffeine builder = Caffeine.newBuilder();
        CaffeineBuilder.configure(builder, name, settings);
        builder.evictionListener((key, value, cause) -> log.debug("Entry evicted from cache [{}] because of {} for key [{}]", new Object[]{name, cause, key}));
        builder.removalListener((key, value, cause) -> log.debug("Entry removed from cache [{}] because of {} for key [{}]", new Object[]{name, cause, key}));
        return builder.build();
    }

    static void configure(Caffeine<?, ?> builder, String name, CacheSettings settings) {
        CaffeineBuilder.set(settings.getExpireAfterAccess(), val -> {
            log.debug("Configuring cache [{}] with expire-after-access [{}]", (Object)name, val);
            builder.expireAfterAccess(val.longValue(), TimeUnit.MILLISECONDS);
        });
        CaffeineBuilder.set(settings.getExpireAfterWrite(), val -> {
            log.debug("Configuring cache [{}] with expire-after-write [{}]", (Object)name, val);
            builder.expireAfterWrite(val.longValue(), TimeUnit.MILLISECONDS);
        });
        CaffeineBuilder.set(settings.getMaxEntries(), val -> {
            log.debug("Configuring cache [{}] with max-entries [{}]", (Object)name, val);
            builder.maximumSize((long)val.intValue());
        });
        if (settings.getStatisticsEnabled(true)) {
            builder.recordStats();
        }
    }

    private static <T extends Number> void set(@Nullable T value, Consumer<T> consumer) {
        if (value != null && value.longValue() > 0L) {
            consumer.accept(value);
        }
    }
}

