/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache.caffeine;

import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.Supplier;
import com.atlassian.cache.impl.CacheEntryListenerSupport;
import com.atlassian.confluence.cache.ConfluenceCache;
import com.atlassian.confluence.impl.cache.caffeine.CaffeineManagedCacheTemplate;
import com.github.benmanes.caffeine.cache.Cache;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

class CaffeineCacheImpl<K, V>
extends CaffeineManagedCacheTemplate
implements ConfluenceCache<K, V> {
    protected final Cache<K, V> caffeine;
    protected final CacheEntryListenerSupport<K, V> listenerSupport;

    CaffeineCacheImpl(String name, CacheSettings settings, Cache<K, V> caffeine, CacheEntryListenerSupport<K, V> listenerSupport) {
        super(name, settings, caffeine);
        this.caffeine = caffeine;
        this.listenerSupport = listenerSupport;
    }

    public void put(K key, V value) {
        this.caffeine.put(this.validateKey(key), value);
        this.listenerSupport.notifyAdd(key, value);
    }

    public @Nullable V putIfAbsent(K key, V value) {
        V existingValue = this.caffeine.asMap().putIfAbsent(this.validateKey(key), value);
        if (existingValue == null) {
            this.listenerSupport.notifyAdd(key, value);
        }
        return existingValue;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        boolean replaced = this.caffeine.asMap().replace(this.validateKey(key), oldValue, newValue);
        if (replaced) {
            this.listenerSupport.notifyUpdate(key, newValue, oldValue);
        }
        return replaced;
    }

    public Collection<K> getKeys() {
        return List.copyOf(this.caffeine.asMap().keySet());
    }

    public @Nullable V get(K key) {
        return (V)this.caffeine.getIfPresent(this.validateKey(key));
    }

    public V get(K key, Supplier<? extends V> valueSupplier) {
        return (V)Objects.requireNonNull(this.caffeine.get(this.validateKey(key), k -> valueSupplier.get()));
    }

    protected K validateKey(K key) {
        return Objects.requireNonNull(key, "Null keys not supported by cache [%s]".formatted(this.getName()));
    }

    public void remove(K key) {
        Object existingValue = this.caffeine.asMap().remove(this.validateKey(key));
        if (existingValue != null) {
            this.listenerSupport.notifyRemove(key, existingValue);
        }
    }

    public boolean remove(K key, V value) {
        boolean replaced = this.caffeine.asMap().remove(this.validateKey(key), value);
        if (replaced) {
            this.listenerSupport.notifyRemove(key, value);
        }
        return replaced;
    }

    public void removeAll() {
        this.caffeine.invalidateAll();
    }

    public void addListener(CacheEntryListener<K, V> listener, boolean includeValues) {
        this.listenerSupport.add(listener, includeValues);
    }

    public void removeListener(CacheEntryListener<K, V> listener) {
        this.listenerSupport.remove(listener);
    }
}

